/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tecgraf.javautils.concurrent.locks.Lock;
import tecgraf.javautils.concurrent.locks.LockDependency;
import tecgraf.javautils.concurrent.locks.LockFuture;
import tecgraf.javautils.concurrent.locks.LockId;
import tecgraf.javautils.concurrent.locks.LockInfo;
import tecgraf.javautils.concurrent.locks.LockListener;
import tecgraf.javautils.concurrent.locks.LockListenerManager;
import tecgraf.javautils.concurrent.locks.LockLogger;
import tecgraf.javautils.concurrent.locks.LockPolicy;
import tecgraf.javautils.concurrent.locks.LockResult;
import tecgraf.javautils.concurrent.locks.SharedAccessObject;
import tecgraf.javautils.concurrent.locks.exceptions.InvalidLockIdException;
import tecgraf.javautils.concurrent.locks.exceptions.ObjectNotLockedException;

public class LockManager {
    private ManagerType managerType;
    private static final long MAX_SLEEP_INTERVAL = 60000L;
    public static final int INFINITE_TIMEOUT = -1;
    private final Map<Object, LockInfo> lockedObjects;
    private final Map<LockId, SharedAccessObject> lockIdMap;
    private boolean exitManagerThread = false;
    private final LockRequestQueue lockRequestQueue;
    private final LockEventQueue lockEventQueue;
    private LockListenerManager listenerManager;
    private LockLogger logger;

    public LockManager() {
        this(ManagerType.NO_REENTRANCE, null);
    }

    public LockManager(ManagerType managerType) {
        this(managerType, null);
    }

    public LockManager(Logger logger) {
        this(ManagerType.NO_REENTRANCE, logger);
    }

    public LockManager(ManagerType managerType, Logger logger) {
        this.managerType = managerType;
        this.logger = LockLogger.getInstance();
        if (logger != null) {
            this.setLogger(logger);
        }
        this.lockedObjects = new Hashtable<Object, LockInfo>();
        this.lockIdMap = new Hashtable<LockId, SharedAccessObject>();
        this.lockRequestQueue = new LockRequestQueue();
        this.lockEventQueue = new LockEventQueue();
        this.listenerManager = new LockListenerManager();
        this.startRequestThread();
        this.startEventThread();
        this.startInvalidLocksCollectorThread();
    }

    public ManagerType getManagerType() {
        return this.managerType;
    }

    public void close() {
        this.stopThreads();
    }

    public Logger getLogger() {
        return this.logger.getLogger();
    }

    public void setLogger(Logger theLogger) {
        this.logger.setLogger(theLogger);
    }

    public LockId acquireLock(LockPolicy lockPolicy, Object ownerKey, SharedAccessObject object, LockDependency ... lockDependencies) {
        if (object == null) {
            throw new IllegalArgumentException("Objeto requisitado n\u00e3o pode ser nulo.");
        }
        LockAcquireResult acquire = this.getLock(lockPolicy, ownerKey, object, null, lockDependencies);
        if (!acquire.lockResult.acquiredLock()) {
            return null;
        }
        return acquire.lockResult.getLockId();
    }

    public LockResult acquireLockWithResult(LockPolicy lockPolicy, Object ownerKey, SharedAccessObject object, LockDependency ... lockDependencies) {
        if (object == null) {
            throw new IllegalArgumentException("Objeto requisitado n\u00e3o pode ser nulo.");
        }
        LockAcquireResult acquire = this.getLock(lockPolicy, ownerKey, object, null, lockDependencies);
        return acquire.lockResult;
    }

    public void tryAcquireLock(LockPolicy lockPolicy, Object ownerKey, SharedAccessObject object, LockFuture future, long timeout, LockDependency ... lockDependencies) {
        if (object == null) {
            throw new IllegalArgumentException("Objeto requisitado n\u00e3o pode ser nulo.");
        }
        this.registerLockRequest(lockPolicy, ownerKey, object, future, timeout, lockDependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized LockAcquireResult getLock(LockPolicy lockPolicy, Object ownerKey, SharedAccessObject object, LockId originatorLockId, LockDependency<SharedAccessObject, SharedAccessObject> ... lockDependencies) {
        LockInfo lockInfo;
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            lockInfo = this.lockedObjects.get(object.getUniqueCode());
            if (lockInfo == null) {
                lockInfo = new LockInfo(object, this.managerType == ManagerType.ALLOWS_REENTRANCE);
            }
            if (!lockPolicy.allowsLock(lockInfo, ownerKey, originatorLockId)) {
                boolean releasedLock = false;
                List<Lock> locks = lockInfo.getLocks(originatorLockId);
                for (Lock lock : locks) {
                    this.logger.fine("Verifica lock inv\u00e1lido");
                    if (!lock.isFirstOrder() || !lock.isInvalid()) continue;
                    this.logger.fine("Lock inv\u00e1lido! Liberando o lock");
                    this.releaseLock(lock.getId());
                    releasedLock = true;
                }
                if (releasedLock) {
                    return this.getLock(lockPolicy, ownerKey, object, originatorLockId, lockDependencies);
                }
                this.logger.fine("% " + ownerKey + " n\u00e3o pode obter lock do objeto " + object);
                return new LockAcquireResult(new LockResult(this.getLockOwnersKeys(object, lockPolicy.getIncompatibleLockPolicies())));
            }
            this.lockedObjects.put(object.getUniqueCode(), lockInfo);
        }
        Lock lock = lockInfo.newLock(lockPolicy, ownerKey, originatorLockId);
        this.logger.fine(ownerKey + " obt\u00e9m lock " + (Object)((Object)lockPolicy) + " do objeto: " + object);
        LockAcquireResult result = new LockAcquireResult(new LockResult(lock.getId()));
        result.eventList.add(new LockEvent(LockEventType.OBJECT_LOCKED, ownerKey, lockPolicy, object));
        LockDependency<SharedAccessObject, SharedAccessObject>[] lockDependencyArray = this.lockIdMap;
        synchronized (this.lockIdMap) {
            this.lockIdMap.put(lock.getId(), object);
            // ** MonitorExit[var9_11] (shouldn't be in output)
            if (lockDependencies != null) {
                for (LockDependency<SharedAccessObject, SharedAccessObject> dependency : lockDependencies) {
                    if (dependency == null) continue;
                    for (SharedAccessObject depObject : dependency.getDependency(object)) {
                        if (depObject == null) continue;
                        LockAcquireResult depLockAcquireResult = this.getLock(dependency.getPolicy(), ownerKey, depObject, lock.getOriginatorLockId(), dependency.getChain());
                        if (depLockAcquireResult.lockResult.acquiredLock()) {
                            lock.addIdDependency(depLockAcquireResult.lockResult.getLockId());
                            result.eventList.addAll(depLockAcquireResult.eventList);
                            continue;
                        }
                        this.releaseLock(lock.getId(), false);
                        result.eventList.clear();
                        return depLockAcquireResult;
                    }
                }
            }
            if (lock.isFirstOrder()) {
                this.lockEventQueue.addEvents(result.eventList);
            }
            return result;
        }
    }

    private void registerLockRequest(LockPolicy lockPolicy, Object ownerKey, SharedAccessObject object, LockFuture future, long timeout, LockDependency<SharedAccessObject, SharedAccessObject> ... lockDependencies) {
        long expirationDate = timeout == -1L ? timeout : System.currentTimeMillis() + timeout;
        LockRequest request = new LockRequest(ownerKey, future, expirationDate, lockPolicy, object, lockDependencies);
        this.lockRequestQueue.addRequest(request);
    }

    public int releaseLock(LockId lockId) {
        return this.releaseLock(lockId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int releaseLock(LockId lockId, boolean broadcastRelease) {
        SharedAccessObject objectLocked;
        if (lockId == null) {
            throw new IllegalArgumentException("Identificador do lock a ser liberado n\u00e3o pode ser nulo.");
        }
        Map<LockId, SharedAccessObject> map = this.lockIdMap;
        synchronized (map) {
            objectLocked = this.lockIdMap.remove(lockId);
        }
        if (objectLocked == null) {
            throw new InvalidLockIdException("Identificador de lock n\u00e3o est\u00e1 relacionado com nenhum objeto.");
        }
        this.logger.fine("Solicitando info para remo\u00e7\u00e3o de " + objectLocked);
        LockInfo lockInfo = null;
        Map<Object, LockInfo> map2 = this.lockedObjects;
        synchronized (map2) {
            lockInfo = this.lockedObjects.get(objectLocked.getUniqueCode());
            if (lockInfo == null) {
                throw new ObjectNotLockedException("N\u00e3o existem locks sobre o objeto " + objectLocked);
            }
            Lock lockRemoved = lockInfo.removeLock(lockId);
            this.logger.fine("Liberado lock de " + objectLocked);
            if (lockRemoved == null) {
                this.logger.fine("Lock removido n\u00e3o existe, \u00e9 igual a null!");
            }
            this.lockRequestQueue.lockReleased();
            if (broadcastRelease) {
                this.lockEventQueue.addEvent(new LockEvent(LockEventType.LOCK_RELEASED, lockRemoved.getOwnerKey(), lockRemoved.getPolicy(), objectLocked));
            }
            for (LockId idRemove : lockRemoved.getIdDependencies()) {
                this.releaseLock(idRemove, broadcastRelease);
            }
            if (lockInfo.getLocks().size() <= 0) {
                this.lockedObjects.remove(objectLocked.getUniqueCode());
                this.logger.fine("Removido info de lock de " + objectLocked);
                return 0;
            }
        }
        return lockInfo.getLocks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceReleaseLock(SharedAccessObject objectLocked) {
        LockInfo lockInfo;
        if (objectLocked == null) {
            throw new IllegalArgumentException("Objeto a ter o lock for\u00e7adamente liberado n\u00e3o pode ser nulo [objectLocked == null].");
        }
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            lockInfo = this.lockedObjects.get(objectLocked.getUniqueCode());
        }
        if (lockInfo == null) {
            throw new ObjectNotLockedException("N\u00e3o existem locks sobre o objeto.");
        }
        for (Lock lock : lockInfo.getLocks()) {
            this.releaseLock(lock.getId(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLock(LockPolicy policy, SharedAccessObject object, Object ownerKey) {
        LockInfo lockInfo;
        if (policy == null || object == null || ownerKey == null) {
            throw new IllegalArgumentException("Par\u00e2metros para verifica\u00e7\u00e3o de lock n\u00e3o podem ser nulos.");
        }
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            lockInfo = this.lockedObjects.get(object.getUniqueCode());
        }
        if (lockInfo == null) {
            return false;
        }
        return lockInfo.hasLock(policy, ownerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockPolicy hasLock(SharedAccessObject object, Object ownerKey) {
        LockInfo lockInfo;
        if (object == null || ownerKey == null) {
            throw new IllegalArgumentException("Par\u00e2metros para verifica\u00e7\u00e3o de lock n\u00e3o podem ser nulos.");
        }
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            lockInfo = this.lockedObjects.get(object.getUniqueCode());
        }
        if (lockInfo == null) {
            return null;
        }
        return lockInfo.getLockPolicy(ownerKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<LockPolicy, Set<Object>> getLockOwnersKeys(SharedAccessObject objectToVerify, LockPolicy ... policies) {
        LockInfo lockInfo;
        if (objectToVerify == null) {
            throw new IllegalArgumentException("Par\u00e2metros para verifica\u00e7\u00e3o de lock n\u00e3o podem ser nulos.");
        }
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            lockInfo = this.lockedObjects.get(objectToVerify.getUniqueCode());
        }
        if (lockInfo == null) {
            return null;
        }
        if (policies.length <= 0) {
            return lockInfo.getLockOwners();
        }
        return lockInfo.getLockOwners(policies);
    }

    public void addLockListener(LockListener listener) {
        this.listenerManager.addLockListener(listener);
    }

    public void addLockListener(Class<?> theClass, LockListener listener) {
        this.listenerManager.addLockListener(theClass, listener);
    }

    public void addLockListener(Object object, LockListener listener) {
        this.listenerManager.addLockListener(object, listener);
    }

    public void removeLockListener(LockListener listener) {
        this.listenerManager.removeLockListener(listener);
    }

    private void startInvalidLocksCollectorThread() {
        Object collector = new Object();
        new Thread(() -> {
            this.logger.config("Inicia a limpeza de locks inv\u00e1lidos");
            while (!this.exitManagerThread) {
                this.clearInvalidLocks();
                Object object = collector;
                synchronized (object) {
                    try {
                        collector.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    private void startRequestThread() {
        new Thread(() -> {
            this.logger.config("Inicia processamento de fila de requisi\u00e7\u00f5es");
            while (!this.exitManagerThread) {
                this.clearInvalidLocks();
                this.lockRequestQueue.processRequests();
                long interval = 60000L;
                LockRequest next = this.lockRequestQueue.getNextRequest();
                if (next != null) {
                    long now = System.currentTimeMillis();
                    long nextTimeout = next.expirationDate - now;
                    interval = nextTimeout < 0L || 60000L < nextTimeout ? 60000L : nextTimeout;
                }
                this.lockRequestQueue.sleep(interval);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvalidLocks() {
        this.logger.fine("Limpa locks inv\u00e1lidos");
        HashSet<Lock> invalidLocks = new HashSet<Lock>();
        Map<Object, LockInfo> map = this.lockedObjects;
        synchronized (map) {
            Set<Map.Entry<Object, LockInfo>> locks = this.lockedObjects.entrySet();
            for (Map.Entry<Object, LockInfo> lockInfoEntry : locks) {
                for (Lock lock : lockInfoEntry.getValue().getLocks()) {
                    this.logger.fine("Verifica lock inv\u00e1lido");
                    if (!lock.isFirstOrder() || !lock.isInvalid()) continue;
                    this.logger.fine("Lock inv\u00e1lido!");
                    invalidLocks.add(lock);
                }
            }
        }
        for (Lock lock : invalidLocks) {
            this.logger.fine("Libera lock inv\u00e1lido");
            this.releaseLock(lock.getId(), true);
        }
    }

    private void startEventThread() {
        new Thread(() -> {
            this.logger.config("Inicia processamento de fila de eventos");
            while (!this.exitManagerThread) {
                this.lockEventQueue.processEvents();
                this.lockEventQueue.sleep();
            }
        }).start();
    }

    private void stopThreads() {
        this.exitManagerThread = true;
    }

    private class LockAcquireResult {
        LockResult lockResult;
        List<LockEvent> eventList;

        LockAcquireResult(LockResult lockResult) {
            this.lockResult = lockResult;
            this.eventList = new ArrayList<LockEvent>();
        }
    }

    private class LockEventQueue {
        private final List<LockEvent> lockEvents = new ArrayList<LockEvent>();

        LockEventQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addEvent(LockEvent lockEvent) {
            List<LockEvent> list = this.lockEvents;
            synchronized (list) {
                this.lockEvents.add(lockEvent);
            }
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addEvents(List<LockEvent> lockEvents) {
            List<LockEvent> list = this.lockEvents;
            synchronized (list) {
                this.lockEvents.addAll(lockEvents);
            }
            this.notify();
        }

        synchronized void sleep() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processEvents() {
            List<LockEvent> list = this.lockEvents;
            synchronized (list) {
                while (this.lockEvents.size() > 0) {
                    LockEvent lockEvent = this.lockEvents.get(0);
                    this.notifyListeners(lockEvent);
                    this.lockEvents.remove(0);
                }
            }
        }

        private void notifyListeners(LockEvent lockEvent) {
            new Thread(() -> {
                Set<LockListener> listeners;
                LockListenerManager lockListenerManager = LockManager.this.listenerManager;
                synchronized (lockListenerManager) {
                    listeners = LockManager.this.listenerManager.getListeners(lockEvent.object);
                }
                for (LockListener listener : listeners) {
                    try {
                        if (lockEvent.eventType == LockEventType.OBJECT_LOCKED) {
                            listener.onObjectLocked(lockEvent.object, lockEvent.ownerKey, lockEvent.lockPolicy);
                            continue;
                        }
                        if (lockEvent.eventType != LockEventType.LOCK_RELEASED) continue;
                        listener.onLockReleased(lockEvent.object, lockEvent.ownerKey, lockEvent.lockPolicy);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    private class LockEvent {
        LockEventType eventType;
        Object ownerKey;
        LockPolicy lockPolicy;
        SharedAccessObject object;

        LockEvent(LockEventType eventType, Object ownerKey, LockPolicy lockPolicy, SharedAccessObject object) {
            this.eventType = eventType;
            this.ownerKey = ownerKey;
            this.lockPolicy = lockPolicy;
            this.object = object;
        }

        public String toString() {
            String str = "\n #Event Type: " + this.eventType.toString() + "\n -Object: " + this.object.toString() + "\n -UniqueCode: " + this.object.getUniqueCode().toString() + "\n -Owner identification: " + this.ownerKey.toString() + "\n -Policy: " + this.lockPolicy.toString() + "\n";
            return str;
        }
    }

    private static enum LockEventType {
        OBJECT_LOCKED,
        LOCK_RELEASED;

    }

    private class LockRequestQueue {
        private final Map<Object, List<LockRequest>> lockRequests = new Hashtable<Object, List<LockRequest>>();
        private final List<LockRequest> sortedLockRequests = new ArrayList<LockRequest>();

        LockRequestQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LockRequest getNextRequest() {
            List<LockRequest> list = this.sortedLockRequests;
            synchronized (list) {
                if (this.sortedLockRequests.size() > 0) {
                    return this.sortedLockRequests.get(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void addRequest(LockRequest request) {
            List<LockRequest> requests;
            Map<Object, List<LockRequest>> map = this.lockRequests;
            synchronized (map) {
                requests = this.lockRequests.get(request.objectToLock);
                if (requests == null) {
                    requests = new ArrayList<LockRequest>();
                    this.lockRequests.put(request.objectToLock, requests);
                }
            }
            requests.add(request);
            this.addSortedRequest(request);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSortedRequest(LockRequest request) {
            List<LockRequest> list = this.sortedLockRequests;
            synchronized (list) {
                if (this.sortedLockRequests.size() <= 0) {
                    this.sortedLockRequests.add(request);
                    return;
                }
                for (int i = 0; i < this.sortedLockRequests.size(); ++i) {
                    if (request.expirationDate >= this.sortedLockRequests.get((int)i).expirationDate) continue;
                    this.sortedLockRequests.add(i, request);
                    return;
                }
                this.sortedLockRequests.add(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized LockRequest[] getRequests(Object object) {
            Map<Object, List<LockRequest>> map = this.lockRequests;
            synchronized (map) {
                List<LockRequest> requests = this.lockRequests.get(object);
                return requests.toArray(new LockRequest[requests.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean remove(Object object, List<LockRequest> requests) {
            Object object2 = this.lockRequests;
            synchronized (object2) {
                List<LockRequest> objectQueue = this.lockRequests.get(object);
                if (objectQueue == null) {
                    return false;
                }
                objectQueue.removeAll(requests);
                if (objectQueue.isEmpty()) {
                    this.lockRequests.remove(object);
                }
            }
            object2 = this.sortedLockRequests;
            synchronized (object2) {
                return this.sortedLockRequests.removeAll(requests);
            }
        }

        synchronized boolean remove(Object object, LockRequest request) {
            ArrayList<LockRequest> requests = new ArrayList<LockRequest>();
            requests.add(request);
            return this.remove(object, requests);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Object[] getAndWaitForQueuesKeys() {
            if (this.size() <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Map<Object, List<LockRequest>> map = this.lockRequests;
            synchronized (map) {
                return this.lockRequests.keySet().toArray(new Object[this.lockRequests.size()]);
            }
        }

        synchronized int size() {
            return this.lockRequests.size();
        }

        synchronized void sleep(long interval) {
            try {
                this.wait(interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        synchronized void lockReleased() {
            this.notify();
        }

        void processRequests() {
            Object[] objects;
            for (Object objectToLock : objects = this.getAndWaitForQueuesKeys()) {
                ArrayList<LockRequest> acquiredLocks = new ArrayList<LockRequest>();
                ArrayList<LockRequest> expiredAndInvalidLockRequests = new ArrayList<LockRequest>();
                LockRequest[] requests = this.getRequests(objectToLock);
                long currentDate = System.currentTimeMillis();
                for (LockRequest lockRequest : requests) {
                    if (!lockRequest.isInvalid()) {
                        lockRequest.future.addAttempt();
                        LockAcquireResult lockAcquireResult = LockManager.this.getLock(lockRequest.lockPolicy, lockRequest.ownerKeyRef.get(), lockRequest.objectToLock, null, lockRequest.dependencies);
                        if (lockAcquireResult.lockResult.acquiredLock()) {
                            acquiredLocks.add(lockRequest);
                            this.notifyObjectLocked(lockRequest, lockAcquireResult.lockResult.getLockId());
                            continue;
                        }
                        if (lockRequest.expirationDate == -1L || currentDate < lockRequest.expirationDate) continue;
                        expiredAndInvalidLockRequests.add(lockRequest);
                        this.notifyLockExpired(lockRequest);
                        continue;
                    }
                    expiredAndInvalidLockRequests.add(lockRequest);
                }
                this.remove(objectToLock, acquiredLocks);
                this.remove(objectToLock, expiredAndInvalidLockRequests);
            }
        }

        void notifyObjectLocked(LockRequest lockRequest, LockId lockId) {
            new Thread(() -> {
                try {
                    lockRequest.future.objectLocked(lockId);
                }
                catch (RemoteException e) {
                    LockManager.this.releaseLock(lockId);
                    LockManager.this.lockRequestQueue.addRequest(lockRequest);
                }
            }).start();
        }

        void notifyLockExpired(LockRequest lockRequest) {
            new Thread(() -> {
                try {
                    lockRequest.future.objectLockExpired();
                }
                catch (RemoteException e) {
                    LockManager.this.lockRequestQueue.addRequest(lockRequest);
                }
            }).start();
        }
    }

    private class LockRequest {
        boolean serverRequested = true;
        WeakReference<Object> ownerKeyRef;
        LockFuture future;
        long expirationDate;
        LockPolicy lockPolicy;
        SharedAccessObject objectToLock;
        LockDependency<SharedAccessObject, SharedAccessObject>[] dependencies;

        LockRequest(LockFuture future, long expirationDate, LockPolicy lockPolicy, SharedAccessObject object, LockDependency<SharedAccessObject, SharedAccessObject> ... dependencies) {
            this.future = future;
            this.expirationDate = expirationDate;
            this.lockPolicy = lockPolicy;
            this.objectToLock = object;
            this.dependencies = dependencies;
        }

        LockRequest(Object ownerKey, LockFuture future, long expirationDate, LockPolicy lockPolicy, SharedAccessObject object, LockDependency<SharedAccessObject, SharedAccessObject> ... dependencies) {
            this(future, expirationDate, lockPolicy, object, dependencies);
            this.ownerKeyRef = new WeakReference<Object>(ownerKey);
            this.serverRequested = false;
        }

        boolean isInvalid() {
            if (this.serverRequested) {
                return false;
            }
            if (this.ownerKeyRef == null) {
                return true;
            }
            Object ownerKey = this.ownerKeyRef.get();
            return ownerKey == null;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("Objeto solicitado para lock: ").append(this.objectToLock.toString());
            if (this.serverRequested) {
                str.append("\n -Requisi\u00e7\u00e3o por thread de servidor");
            } else if (this.ownerKeyRef.get() != null) {
                str.append("\n -Identificador do Usu\u00e1rio: ").append(this.ownerKeyRef.get());
            } else {
                str.append("\n -Refer\u00eancia ao usu\u00e1rio inv\u00e1lida.");
            }
            str.append("\n -Data de expira\u00e7\u00e3o: ").append(new Date(this.expirationDate));
            str.append("\n -Pol\u00edtica de Lock: ").append(this.lockPolicy.toString());
            return str.toString();
        }
    }

    public static enum ManagerType {
        ALLOWS_REENTRANCE,
        NO_REENTRANCE;

    }
}

