/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationObjectAction;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.table.RegistrationTablePanel;

public class RegistrationTableMouseListener<M, I>
extends MouseAdapter {
    private final RegistrationTablePanel<M, I> tablePanel;
    private final IRegistrationDescriptor<M, I> descriptor;

    private void tryPopupMenu(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        if (!e.isPopupTrigger()) {
            return;
        }
        Object source = e.getSource();
        JTable table = (JTable)source;
        if (!table.isEnabled()) {
            return;
        }
        M selectedObject = this.tablePanel.getSelectedObject();
        RegistrationMainPanel<M, I> mainPanel = this.tablePanel.getMainPanel();
        List<RegistrationObjectAction<M, I>> actions = this.descriptor.getPopupMenuActions(mainPanel, selectedObject);
        JPopupMenu menu = new JPopupMenu();
        if (actions != null && actions.size() > 0) {
            for (AbstractAction abstractAction : actions) {
                menu.add(abstractAction);
            }
        }
        menu.show(this.tablePanel, e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.tryPopupMenu(e);
    }

    private void tryEdtion(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        Object source = e.getSource();
        JTable table = (JTable)source;
        if (!table.isEnabled()) {
            return;
        }
        RegistrationMainPanel<M, I> mainPanel = this.tablePanel.getMainPanel();
        mainPanel.setMode(RegistrationMainPanel.Mode.EDIT);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.tryPopupMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.tryPopupMenu(e);
    }

    RegistrationTableMouseListener(RegistrationTablePanel<M, I> tablePanel, IRegistrationDescriptor<M, I> descriptor) {
        this.tablePanel = tablePanel;
        this.descriptor = descriptor;
    }
}

