/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableReportItem;
import tecgraf.javautils.gui.print.PrintableUI;

public class PrintableHeader
implements PrintableReportItem,
ImageObserver {
    private ImageIcon leftImage;
    private ImageIcon rightImage;
    private float height;
    private boolean done;
    private float width;

    public PrintableHeader(ImageIcon leftImage, ImageIcon rightImage) {
        this.leftImage = leftImage;
        this.rightImage = rightImage;
        if (leftImage == null && rightImage == null) {
            throw new IllegalArgumentException("all image null");
        }
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        int leftHeight = this.leftImage == null ? 0 : this.leftImage.getIconHeight();
        int rightHeight = this.rightImage == null ? 0 : this.rightImage.getIconHeight();
        this.height = Math.max(leftHeight, rightHeight);
        this.height += (float)g2.getFontMetrics(PrintableUI.PRINT_FONT).getHeight();
        return (double)this.height <= format.getImageableHeight();
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
        int y;
        int leftHeight = this.leftImage == null ? 0 : this.leftImage.getIconHeight();
        int rightHeight = this.rightImage == null ? 0 : this.rightImage.getIconHeight();
        this.height = Math.max(leftHeight, rightHeight);
        if ((double)(this.height + (float)g2.getFontMetrics(PrintableUI.PRINT_FONT).getHeight()) > format.getImageableHeight()) {
            return false;
        }
        this.width = (float)format.getImageableWidth();
        int x = (int)format.getImageableX();
        int baseY = (int)format.getImageableY();
        if (this.leftImage != null) {
            y = baseY + (int)((this.height - (float)leftHeight) / 2.0f);
            this.drawImage(this.leftImage, g2, x, y);
        }
        if (this.rightImage != null) {
            y = baseY + (int)((this.height - (float)rightHeight) / 2.0f);
            this.drawImage(this.rightImage, g2, x += (int)format.getImageableWidth() - this.rightImage.getIconWidth(), y);
        }
        this.height += (float)g2.getFontMetrics(PrintableUI.PRINT_FONT).getHeight();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(ImageIcon image, Graphics2D g2, int x, int y) {
        int height = image.getIconHeight();
        int width = image.getIconWidth();
        Image img = image.getImage();
        this.done = false;
        boolean drawn = g2.drawImage(img, x, y, width, height, this);
        if (!drawn) {
            while (true) {
                PrintableHeader printableHeader = this;
                synchronized (printableHeader) {
                    if (this.done) {
                        break;
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.done = (infoflags & 0x70) != 0;
        return !this.done;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
    }

    @Override
    public float getWidth() {
        return this.width;
    }
}

