/*
 * $Id: ColorButton.java 108625 2010-08-03 17:44:34Z pasti $
 */

package tecgraf.javautils.gui.colorbutton;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JColorChooser;

/**
 * Classe para criao de um boto de escolha de cores padro.
 *
 * @see ColorButtonSample
 *
 * @author Tecgraf/PUC-Rio
 */
public class ColorButton extends JButton {

  /**
   * Lista de listeners de escolha do boto.
   */
  private final List<ColorButtonChoiceListener> listeners =
    new ArrayList<ColorButtonChoiceListener>();

  /**
   * Mtodo de ajuste da callback de seleo de cor.
   */
  private final void initAttributes() {

    setOpaque(true);
    setBorderPainted(false);
    setFocusPainted(false);

    addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        final Color oldColor = getBackground();
        Color newColor =
          JColorChooser.showDialog(ColorButton.this, "", oldColor);
        if (newColor == null) {
          newColor = oldColor;
        }
        setBackground(newColor);
        for (int i = 0; i < listeners.size(); i++) {
          final ColorButtonChoiceListener lst = listeners.get(i);
          if (lst != null) {
            lst.colorChosen(ColorButton.this, newColor);
          }
        }
      }
    });
  }

  /**
   * Consulta a cor corrente.
   *
   * @return a cor corrente.
   */
  public final Color getColor() {
    return getBackground();
  }

  /**
   * Ajusta a cor corrente.
   *
   * @param color a cor a ser ajustada.
   */
  public final void setColor(final Color color) {
    setBackground(color);
  }

  /**
   * Adio de um listener de escolha de cor no boto.
   *
   * @param listener o listener (<code>ColorButtonListener</code>).
   * @see ColorButtonChoiceListener
   */
  public final void addColorButtonChoiceListener(
    final ColorButtonChoiceListener listener) {
    listeners.add(listener);
  }

  /**
   * Construtor padro.
   */
  public ColorButton() {
    this(null);
  }

  /**
   * Construtor com inicializao de cor.
   *
   * @param color a cor inicial do boto.
   */
  public ColorButton(final Color color) {
    // Garante uma altura mnima razovel para o boto.
    setText(" ");

    initAttributes();
    setColor(color);
  }
}
