/*
 * $Id: PrintableSeparator.java 138821 2013-03-11 17:32:49Z allan $
 */
package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;

/**
 * Imprime um espaamento quadrado com a altura e a largura iguais  altura de
 * determinada fonte.
 */
public class PrintableSeparator implements PrintableReportItem {
  /** Fonte que determina a altura do espao */
  private Font font;
  /** Altura do espaamento */
  private float height;
  /** Indica se a fonte pode ser alterada pela configurao */
  private boolean changeFont;

  /**
   * Contrutor.
   * 
   * @param font que determina a altura do espao.
   */
  public PrintableSeparator(Font font) {
    this.font = font;
  }

  /**
   * Contrutor.
   * 
   * @param font que determina a altura do espao.
   * @param changeFont indica se a fonte pode ser alterada pela configurao.
   */
  public PrintableSeparator(Font font, boolean changeFont) {
    this.font = font;
    this.changeFont = changeFont;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
    return printSeparator(g2, format);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean print(Graphics2D g2, PageFormat format, int pageIndex) {
    return printSeparator(g2, format);
  }

  /**
   * Imprime o separador.
   * 
   * @param g2 contexto grfico.
   * @param format formato da pgina a ser impressa.
   * 
   * @return verdadeiro se o separador foi impresso.
   */
  private boolean printSeparator(Graphics2D g2, PageFormat format) {
    height = g2.getFontMetrics(font).getHeight();
    return (height <= format.getImageableHeight());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public float getHeight() {
    return height;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void initPrinting(PrintConfiguration configuration) {
    if (!changeFont) {
      return;
    }
    font = font.deriveFont(font.getSize() * configuration.getFontRate());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public float getWidth() {
    return height;
  }
}
