/**
 * $Id: DefaultObjectTableProvider.java 119238 2011-06-20 17:40:49Z costa $
 */
package tecgraf.javautils.gui.table;

/**
 * Implementao default de um provedor de dados para tabelas, para os casos em
 * que as linhas da tabela esto associadas a objetos.
 * <p>
 * <b>IMPORTANTE:</b> Esta classe foi criada apenas para facilitar a adaptao
 * das aplicaes que usavam {@link ObjectTableProvider} antes do mtodo
 * {@link #getCellValues(Object)} ser removido desta. Sua implementao de
 * {@link #getCellValue(Object, int)}  ineficiente pois usa o mtodo
 * {@link #getCellValues(Object)} (que obtm <b>todos</b> os valores da linha em
 * questo) para retornar o valor de uma nica clula.
 * 
 * @author Tecgraf
 * @param <T> tipo associado a cada linha da tabela
 * 
 * @deprecated implementar diretamente {@link ObjectTableProvider} resulta em
 *             melhor desempenho
 */
@Deprecated
public abstract class DefaultObjectTableProvider<T> implements
  ObjectTableProvider<T> {

  /**
   * Dado um objeto-linha qualquer, retorna um array de objetos contendo os
   * valores das clulas correspondentes a essa linha.
   * <p>
   * IMPORTANTE: Retorne somente os tipos de dados brutos das propriedades a
   * serem exibidas (<code>Date, Double, String</code>, etc). No utilize esse
   * mtodo para formatar a sada (exemplo: casas decimais em tipos
   * <i>float</i>, formato de datas), pois isso poder afetar a ordenao.
   * Aplique preferencialmente renderizadores na tabela para este fim.
   * 
   * @param row objeto-linha.
   * 
   * @return array de valores para as clulas.
   */
  public abstract Object[] getCellValues(T row);

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getCellValue(T row, int col) {
    Object[] cells = getCellValues(row);
    if (cells == null) {
      return "???";
    }
    return cells[col];
  }
}
