package tecgraf.javautils.gui.table;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

/**
 * Adaptador do modelo de TreeTable.
 *
 * @author Tecgraf/PUC-Rio
 */
public class TreeTableModelAdapter extends AbstractTableModel {

  /** rvore da tabela */
  private JTree tree;

  /** Modelo da TreeTable */
  private TreeTableModel treeTableModel;

  /**
   * Construtor.
   *
   * @param tree a rvore da tabela.
   * @param treeTableModel modelo da TreeTableTree que ser adaptado  tabela.
   */
  public TreeTableModelAdapter(JTree tree, TreeTableModel treeTableModel) {
    this.tree = tree;
    this.treeTableModel = treeTableModel;

    tree.addTreeExpansionListener(new TreeExpansionListener() {
      @Override
      public void treeExpanded(TreeExpansionEvent event) {
        fireTableDataChanged();
      }

      @Override
      public void treeCollapsed(TreeExpansionEvent event) {
        fireTableDataChanged();
      }
    });
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return treeTableModel.getColumnCount();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int column) {
    return treeTableModel.getColumnName(column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int column) {
    return treeTableModel.getColumnClass(column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    return tree.getRowCount();
  }

  /**
   * Obtm o caminho para um n a partir de uma linha da tabela.
   *
   * @param row a linha da tabela.
   * @return o caminho na rvore para o n correspondente.
   */
  public Object nodeForRow(int row) {
    TreePath treePath = tree.getPathForRow(row);
    return treePath.getLastPathComponent();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int row, int column) {
    return treeTableModel.getValueAt(nodeForRow(row), column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int row, int column) {
    return treeTableModel.isCellEditable(nodeForRow(row), column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setValueAt(Object value, int row, int column) {
    treeTableModel.setValueAt(value, nodeForRow(row), column - 1);
  }

  /**
   * Retorna o modelo encapsulado dentro deste adaptador
   * 
   * @return o modelo
   */
  public TreeTableModel getTreeTableModel() {
    return treeTableModel;
  }
}