/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.parser;

import java.util.ArrayList;
import tecgraf.javautils.jexpression.exception.JExpressionSyntaxErrorException;
import tecgraf.javautils.jexpression.parser.TokenMemoization;
import tecgraf.javautils.jexpression.parser.model.BinaryOp;
import tecgraf.javautils.jexpression.parser.model.DoubleValue;
import tecgraf.javautils.jexpression.parser.model.Exp;
import tecgraf.javautils.jexpression.parser.model.Field;
import tecgraf.javautils.jexpression.parser.model.FunctionCall;
import tecgraf.javautils.jexpression.parser.model.Group;
import tecgraf.javautils.jexpression.parser.model.Index;
import tecgraf.javautils.jexpression.parser.model.Question;
import tecgraf.javautils.jexpression.parser.model.StringValue;
import tecgraf.javautils.jexpression.parser.model.UnaryOp;
import tecgraf.javautils.jexpression.parser.model.Var;
import tecgraf.javautils.jexpression.scanner.Symbol;
import tecgraf.javautils.jexpression.scanner.Token;

public class JParser {
    public Exp parse(String input) throws JExpressionSyntaxErrorException {
        if (input == null) {
            throw new IllegalArgumentException("input n\u00e3o pode ser nulo.");
        }
        TokenMemoization m = new TokenMemoization(input);
        Exp exp = this.exp(m);
        if (exp == null) {
            String f = "'%s' N\u00e3o \u00e9 uma express\u00e3o v\u00e1lida";
            String msg = String.format(f, input);
            throw new JExpressionSyntaxErrorException(msg, 0);
        }
        if (m.hasMoreTokens()) {
            Token token = m.token();
            String f = "Express\u00e3o inv\u00e1lida a partir de '%s'";
            String msg = String.format(f, token.getValue());
            throw new JExpressionSyntaxErrorException(msg, token.getLineNumber());
        }
        return exp;
    }

    private Exp exp(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp1(m);
        if (m.isTerminal(Symbol.QUESTION)) {
            Token question = m.token();
            m.commit();
            Exp then = this.exp(m);
            if (exp == null || then == null) {
                String msg = "Faltam operandos para o operador '?'";
                throw new JExpressionSyntaxErrorException(msg, question.getLineNumber());
            }
            if (!m.isTerminal(Symbol.COLON)) {
                String msg = "Falta o operador ':' para o dado '?'";
                throw new JExpressionSyntaxErrorException(msg, question.getLineNumber());
            }
            m.commit();
            Exp otherwise = this.exp(m);
            if (otherwise == null) {
                String msg = "Faltam operandos para o operador ':'";
                throw new JExpressionSyntaxErrorException(msg, question.getLineNumber());
            }
            exp = new Question(exp, then, otherwise);
        }
        return exp;
    }

    private Exp exp1(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp2(m);
        while (m.isTerminal(Symbol.OR)) {
            Token or = m.token();
            m.commit();
            Exp second = this.exp2(m);
            if (exp == null || second == null) {
                String msg = "Faltam operandos para o operador '||'";
                throw new JExpressionSyntaxErrorException(msg, or.getLineNumber());
            }
            exp = new BinaryOp(exp, Symbol.OR, second);
        }
        return exp;
    }

    private Exp exp2(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp3(m);
        while (m.isTerminal(Symbol.AND)) {
            Token and = m.token();
            m.commit();
            Exp second = this.exp3(m);
            if (exp == null || second == null) {
                String msg = "Faltam operandos para o operador '&&'";
                throw new JExpressionSyntaxErrorException(msg, and.getLineNumber());
            }
            exp = new BinaryOp(exp, Symbol.AND, second);
        }
        return exp;
    }

    private Exp exp3(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp4(m);
        while (m.isTerminal(Symbol.LOWER, Symbol.GREATER, Symbol.LOWER_EQ, Symbol.GREATER_EQ, Symbol.NOT_EQUAL, Symbol.EQUAL)) {
            Token op = m.token();
            m.commit();
            Exp second = this.exp4(m);
            if (exp == null || second == null) {
                String f = "Faltam operandos para o operador '%s'";
                String graphic = op.getType().graphic;
                String msg = String.format(f, graphic);
                throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
            }
            exp = new BinaryOp(exp, op.getType(), second);
        }
        return exp;
    }

    private Exp exp4(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp5(m);
        while (m.isTerminal(Symbol.PLUS, Symbol.MINUS)) {
            Token op = m.token();
            m.commit();
            Exp second = this.exp5(m);
            if (exp == null || second == null) {
                String f = "Faltam operandos para o operador '%s'";
                String graphic = op.getType().graphic;
                String msg = String.format(f, graphic);
                throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
            }
            exp = new BinaryOp(exp, op.getType(), second);
        }
        return exp;
    }

    private Exp exp5(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp6(m);
        while (m.isTerminal(Symbol.TIMES, Symbol.DIVIDE)) {
            Token op = m.token();
            m.commit();
            Exp second = this.exp6(m);
            if (exp == null || second == null) {
                String f = "Faltam operandos para o operador '%s'";
                String graphic = op.getType().graphic;
                String msg = String.format(f, graphic);
                throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
            }
            exp = new BinaryOp(exp, op.getType(), second);
        }
        return exp;
    }

    private Exp exp6(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (m.isTerminal(Symbol.NOT, Symbol.MINUS)) {
            Token op = m.token();
            m.commit();
            Exp exp = this.exp6(m);
            if (exp == null) {
                String f = "Falta operando para o operador un\u00e1rio '%s'";
                String graphic = op.getType().graphic;
                String msg = String.format(f, graphic);
                throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
            }
            return new UnaryOp(op.getType(), exp);
        }
        return this.exp7(m);
    }

    private Exp exp7(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp8(m);
        if (exp == null) {
            return null;
        }
        ArrayList<Exp> exps = new ArrayList<Exp>();
        exps.add(exp);
        while (m.isTerminal(Symbol.POW)) {
            Token pow = m.token();
            m.commit();
            Exp exponent = this.exp6(m);
            if (exponent == null) {
                String msg = "Faltam operandos para o operador '^'";
                throw new JExpressionSyntaxErrorException(msg, pow.getLineNumber());
            }
            exps.add(exponent);
        }
        if (exps.size() == 1) {
            return (Exp)exps.get(0);
        }
        exp = null;
        for (int i = exps.size() - 1; i > 0; --i) {
            Exp second = (Exp)exps.get(i);
            Exp first = (Exp)exps.get(i - 1);
            exp = new BinaryOp(first, Symbol.POW, second);
            exps.set(i - 1, exp);
        }
        return exp;
    }

    private Exp exp8(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.exp9(m);
        if (exp == null) {
            return null;
        }
        while (m.isTerminal(Symbol.DOT, Symbol.L_BRACKET)) {
            while (m.isTerminal(Symbol.DOT)) {
                int lineNumber = m.token().getLineNumber();
                m.commit();
                if (!m.isTerminal(Symbol.NAME)) {
                    String msg = "Faltam operandos para o operador '.'";
                    throw new JExpressionSyntaxErrorException(msg, lineNumber);
                }
                Token name = m.token();
                m.commit();
                exp = new Field(exp, name.getValue());
            }
            while (m.isTerminal(Symbol.L_BRACKET)) {
                Token op = m.token();
                m.commit();
                Exp second = this.exp(m);
                if (exp == null || second == null) {
                    String f = "Faltam \u00edndice do valor '%s'";
                    String msg = String.format(f, exp);
                    throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
                }
                if (!m.isTerminal(Symbol.R_BRACKET)) {
                    String msg = "Colchetes desbalanceados ']'";
                    throw new JExpressionSyntaxErrorException(msg, op.getLineNumber());
                }
                m.commit();
                exp = new Index(exp, second);
            }
        }
        return exp;
    }

    private Exp exp9(TokenMemoization m) throws JExpressionSyntaxErrorException {
        Exp exp = this.doubleValue(m);
        if (exp != null) {
            return exp;
        }
        exp = this.stringValue(m);
        if (exp != null) {
            return exp;
        }
        exp = this.functioncall(m);
        if (exp != null) {
            return exp;
        }
        exp = this.var(m);
        if (exp != null) {
            return exp;
        }
        exp = this.group(m);
        if (exp != null) {
            return exp;
        }
        return null;
    }

    private Exp doubleValue(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (!m.isTerminal(Symbol.DOUBLE)) {
            return null;
        }
        Token token = m.token();
        m.commit();
        String value = token.getValue();
        return new DoubleValue(Double.valueOf(value));
    }

    private Exp stringValue(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (!m.isTerminal(Symbol.STRING)) {
            return null;
        }
        Token token = m.token();
        m.commit();
        String value = token.getValue();
        return new StringValue(value);
    }

    private Exp functioncall(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (!m.isTerminal(Symbol.NAME)) {
            return null;
        }
        Token name = m.token();
        m.commit();
        if (!m.isTerminal(Symbol.L_PAREN)) {
            m.rollback();
            return null;
        }
        m.commit();
        ArrayList<Exp> params = new ArrayList<Exp>();
        Exp exp = this.exp(m);
        if (exp != null) {
            params.add(exp);
            while (m.isTerminal(Symbol.COMMA)) {
                m.commit();
                exp = this.exp(m);
                if (exp == null) {
                    String f = "Falta par\u00e2metro ap\u00f3s ',' na chamada de fun\u00e7\u00e3o '%s'";
                    String msg = String.format(f, name.getValue());
                    throw new JExpressionSyntaxErrorException(msg, name.getLineNumber());
                }
                params.add(exp);
            }
        }
        if (!m.isTerminal(Symbol.R_PAREN)) {
            String f = "Falta ')' para a dada chamada de fun\u00e7\u00e3o '%s'";
            String msg = String.format(f, name.getValue());
            throw new JExpressionSyntaxErrorException(msg, name.getLineNumber());
        }
        m.commit();
        return new FunctionCall(name.getValue(), params);
    }

    private Var var(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (!m.isTerminal(Symbol.NAME)) {
            return null;
        }
        Token name = m.token();
        m.commit();
        return new Var(name.getValue());
    }

    private Exp group(TokenMemoization m) throws JExpressionSyntaxErrorException {
        if (!m.isTerminal(Symbol.L_PAREN)) {
            return null;
        }
        int lineNumber = m.token().getLineNumber();
        m.commit();
        Exp exp = this.exp(m);
        if (exp == null) {
            String msg = "Express\u00e3o esperada ap\u00f3s '('";
            throw new JExpressionSyntaxErrorException(msg, lineNumber);
        }
        if (!m.isTerminal(Symbol.R_PAREN)) {
            String msg = "Par\u00eanteses desbalanceados ')'";
            throw new JExpressionSyntaxErrorException(msg, lineNumber);
        }
        m.commit();
        return new Group(exp);
    }
}

