/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.samples;

import java.nio.charset.Charset;
import java.util.Scanner;
import tecgraf.javautils.jexpression.JExpression;
import tecgraf.javautils.jexpression.util.CalculatorHandler;

public class Calculator {
    public static void main(String[] args) {
        Charset charset = Charset.defaultCharset();
        Scanner scanner = new Scanner(System.in, charset.name());
        CalculatorHandler handler = new CalculatorHandler();
        handler.registerBasicFunctions();
        while (true) {
            System.out.println("Digite express\u00e3o (op\u00e7\u00f5es: 'help' e 'exit'):");
            String line = scanner.nextLine();
            if (line.trim().isEmpty()) {
                System.out.println("");
                continue;
            }
            if (line.contains("help")) {
                System.out.println("Para definir vari\u00e1veis: define <nome> <valor>");
                continue;
            }
            if (line.contains("define")) {
                String[] values = line.split(" +");
                if (values.length != 3) {
                    System.out.println("Opera\u00e7\u00e3o 'define' requer 2 argumentos.");
                    continue;
                }
                Object value = Calculator.getValue(values[2]);
                if (value == null) continue;
                handler.addVariable(values[1], value);
                continue;
            }
            if (line.contains("exit")) break;
            Calculator.evaluate(line, handler);
        }
        scanner.close();
    }

    private static Object getValue(String value) {
        if (value.equals("true")) {
            return Boolean.TRUE;
        }
        if (value.equals("false")) {
            return Boolean.FALSE;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            System.out.println("Aviso: opera\u00e7\u00e3o 'define' fez atribui\u00e7\u00e3o como string.");
            return value;
        }
    }

    private static void evaluate(String entry, CalculatorHandler handler) {
        try {
            JExpression expression = JExpression.compile(entry);
            Object result = expression.eval(handler);
            if (result instanceof String) {
                System.out.println("String: \"" + result + "\"");
            } else if (result instanceof Boolean) {
                boolean r = (Boolean)result;
                System.out.println("Boolean: " + (r ? Boolean.TRUE : Boolean.FALSE));
            } else if (result instanceof Double) {
                System.out.println("Number: " + result);
            } else {
                System.out.println("Object: " + result);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

