/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.jexpression.util.function;

import tecgraf.javautils.jexpression.util.function.JExpressionFunction;

public enum BasicFunctions {
    EXP(BasicFunctions.createExpFunction()),
    LOG10(BasicFunctions.createLog10Function()),
    LOG(BasicFunctions.createLogFunction()),
    ROUND(BasicFunctions.createRoundFunction()),
    FLOOR(BasicFunctions.createFloorFunction()),
    ABS(BasicFunctions.createAbsFunction()),
    CBRT(BasicFunctions.createCbrtFunction()),
    SQRT(BasicFunctions.createSqrtFunction()),
    TAN(BasicFunctions.createTanFunction()),
    SIN(BasicFunctions.createSinFunction()),
    COS(BasicFunctions.createCosFunction()),
    MAX(BasicFunctions.createMaxFunction()),
    MIN(BasicFunctions.createMinFunction()),
    TONUMBER(BasicFunctions.createToNumberFunction()),
    TOBOOLEAN(BasicFunctions.createToBooleanFunction()),
    TOSTRING(BasicFunctions.createToStringFunction()),
    STRLEN(BasicFunctions.createStrlenFunction());

    public final JExpressionFunction function;

    private BasicFunctions(JExpressionFunction function) {
        this.function = function;
    }

    private static JExpressionFunction createExpFunction() {
        return new JExpressionFunction("exp"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.exp((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createLog10Function() {
        return new JExpressionFunction("log10"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.log10((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createLogFunction() {
        return new JExpressionFunction("log"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.log((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createRoundFunction() {
        return new JExpressionFunction("round"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Long result = Math.round((Double)params[0]);
                return result.doubleValue();
            }
        };
    }

    private static JExpressionFunction createFloorFunction() {
        return new JExpressionFunction("floor"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.floor((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createAbsFunction() {
        return new JExpressionFunction("abs"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.abs((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createCbrtFunction() {
        return new JExpressionFunction("cbrt"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.cbrt((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createSqrtFunction() {
        return new JExpressionFunction("sqrt"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.sqrt((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createTanFunction() {
        return new JExpressionFunction("tan"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.tan((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createSinFunction() {
        return new JExpressionFunction("sin"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.sin((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createCosFunction() {
        return new JExpressionFunction("cos"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                return Math.cos((Double)params[0]);
            }
        };
    }

    private static JExpressionFunction createMaxFunction() {
        return new JExpressionFunction("max"){

            @Override
            public Object call(Object ... params) {
                if (params.length < 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber pelo menos 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Double max = (Double)params[0];
                for (Object param : params) {
                    max = Math.max(max, (Double)param);
                }
                return max;
            }
        };
    }

    private static JExpressionFunction createMinFunction() {
        return new JExpressionFunction("min"){

            @Override
            public Object call(Object ... params) {
                if (params.length < 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber pelo menos 1 par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Double min = (Double)params[0];
                for (Object param : params) {
                    min = Math.min(min, (Double)param);
                }
                return min;
            }
        };
    }

    private static JExpressionFunction createStrlenFunction() {
        return new JExpressionFunction("strlen"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber um \u00fanico par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Object param = params[0];
                if (param instanceof String) {
                    return (double)((String)param).length();
                }
                String f = "Fun\u00e7\u00e3o '%s' deve receber um par\u00e2metro string.";
                throw new IllegalArgumentException(String.format(f, this.getName()));
            }
        };
    }

    private static JExpressionFunction createToBooleanFunction() {
        return new JExpressionFunction("toboolean"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber um \u00fanico par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Object param = params[0];
                if (param instanceof String) {
                    String str = ((String)param).trim();
                    if (str.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (str.equalsIgnoreCase("false")) {
                        return Boolean.TRUE;
                    }
                    String f = "Fun\u00e7\u00e3o '%s' falhou na convers\u00e3o de '%s' para booleano ('true' or 'false').";
                    throw new IllegalArgumentException(String.format(f, this.getName(), param));
                }
                String f = "Fun\u00e7\u00e3o '%s' deve receber um par\u00e2metro string.";
                throw new IllegalArgumentException(String.format(f, this.getName()));
            }
        };
    }

    private static JExpressionFunction createToNumberFunction() {
        return new JExpressionFunction("tonumber"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber um \u00fanico par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Object param = params[0];
                if (param instanceof String) {
                    try {
                        return Double.parseDouble((String)param);
                    }
                    catch (NumberFormatException nfe) {
                        String f = "Fun\u00e7\u00e3o '%s' falhou na convers\u00e3o de '%s' para n\u00famero.";
                        throw new IllegalArgumentException(String.format(f, this.getName(), param));
                    }
                }
                String f = "Fun\u00e7\u00e3o '%s' deve receber um par\u00e2metro string.";
                throw new IllegalArgumentException(String.format(f, this.getName()));
            }
        };
    }

    private static JExpressionFunction createToStringFunction() {
        return new JExpressionFunction("tostring"){

            @Override
            public Object call(Object ... params) {
                if (params.length != 1) {
                    String f = "Fun\u00e7\u00e3o '%s' deve receber um \u00fanico par\u00e2metro.";
                    throw new IllegalArgumentException(String.format(f, this.getName()));
                }
                Object param = params[0];
                return param.toString();
            }
        };
    }
}

