/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tecgraf.javautils.launcher.SplashScreen;

public class DefaultSplashScreen
extends SplashScreen {
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public DefaultSplashScreen() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.add((Component)this.getMessageLabel(), "North");
        panel.add((Component)this.getProgressBar(), "Center");
        this.setContentPane(panel);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(350, dim.height);
    }

    public JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        }
        return this.messageLabel;
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setBorderPainted(false);
            this.progressBar.setForeground(new Color(100, 100, 255));
            this.progressBar.setBackground(Color.LIGHT_GRAY);
        }
        return this.progressBar;
    }

    @Override
    public void setMessage(String message) {
        this.getMessageLabel().setText(message);
    }

    @Override
    public void error(String message) {
        this.getMessageLabel().setText(message);
    }

    @Override
    public void setProgressBarIndeterminate(boolean indeterminate) {
        this.getProgressBar().setIndeterminate(indeterminate);
        this.getProgressBar().setValue(0);
        this.getProgressBar().setMaximum(100);
    }

    @Override
    public void setProgressBarValue(int progress) {
        this.getProgressBar().setValue(progress);
    }
}

