/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.launcher;

import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Logger;

public class LauncherProperties {
    public static final String PROTOCOL_VERSION_PROPERTY = "protocolVersion";
    public static final String WRONG_PROTOCOL_VERSION_MESSAGE_PROPERTY = "wrongProtocolVersionMessage";
    public static final String SHORTCUT_CREATION_MESSAGE_PROPERTY = "shortcutCreationMessage";
    public static final String SHORTCUT_CREATION_SUCCESS_MESSAGE_PROPERTY = "shortcutCreationSuccessMessage";
    public static final String SHORTCUT_CREATION_ERROR_MESSAGE_PROPERTY = "shortcutCreationErrorMessage";
    public static final String LAUNCHER_FILENAME_PROPERTY = "launcherFilename";
    public static final String LAUNCHER_PROPERTIES_FILE = "launcher.properties";
    private final Properties properties;
    private final String propertiesUrl;
    private final Logger logger;

    private LauncherProperties(Properties properties, String propertiesUrl, Logger logger) {
        this.properties = properties;
        this.propertiesUrl = propertiesUrl;
        this.logger = logger;
    }

    public static LauncherProperties load(String host, Logger logger) {
        String propertiesUrl = host + LAUNCHER_PROPERTIES_FILE;
        logger.info("launcherPropertiesUrl: " + propertiesUrl);
        Properties properties = new Properties();
        try {
            URL url = new URL(propertiesUrl);
            properties.load(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel carregar o arquivo de propriedades: " + propertiesUrl, e);
        }
        return new LauncherProperties(properties, propertiesUrl, logger);
    }

    private String getMandatoryProperty(String property) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            throw new IllegalStateException("A propriedade " + property + " n\u00e3o foi definida no arquivo de properties: " + this.propertiesUrl);
        }
        return value;
    }

    private String getProperty(String property, String defaultValue) {
        String value = this.properties.getProperty(property);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getProtocolVersion() {
        return this.getMandatoryProperty(PROTOCOL_VERSION_PROPERTY);
    }

    public String getWrongInstallerVersionMessage() {
        return this.getProperty(WRONG_PROTOCOL_VERSION_MESSAGE_PROPERTY, "O aplicativo passou por algumas mudan\u00e7as e desta vez, para poder utiliz\u00e1-las, ser\u00e1 necess\u00e1rio:\n\n1. Excluir o atalho em sua \u00e1rea de trabalho\n2. Executar novamente o instalador\n\nN\u00e3o se preocupe! Isso n\u00e3o ser\u00e1 necess\u00e1rio a cada vers\u00e3o nova do aplicativo.");
    }

    public String getLauncherFileName() {
        return this.getProperty(LAUNCHER_FILENAME_PROPERTY, "instalador.jar");
    }

    public String getShortcutCreationMessage() {
        return this.getProperty(SHORTCUT_CREATION_MESSAGE_PROPERTY, "Criando \u00edcone na \u00e1rea de trabalho...");
    }

    public String getShortcutCreationSuccessMessage() {
        return this.getProperty(SHORTCUT_CREATION_SUCCESS_MESSAGE_PROPERTY, "\u00cdcone criado com sucesso na sua \u00e1rea de trabalho.");
    }

    public String getShortcutCreationErrorMessage(String jarPath) {
        String message = this.getProperty(SHORTCUT_CREATION_ERROR_MESSAGE_PROPERTY, "N\u00e3o foi poss\u00edvel criar o atalho para o arquivo '%1$s' na sua \u00e1rea de trabalho.\nSer\u00e1 necess\u00e1rio criar manualmente.");
        return String.format(message, jarPath);
    }

    public String getServerURL(String environment) {
        return this.getMandatoryProperty("serverHost." + environment);
    }
}

