package tecgraf.javautils.parsers.exception;

import tecgraf.javautils.parsers.Session;

/**
 * Representa uma exceo do autmato finito (
 * {@link tecgraf.javautils.parsers.FiniteAutomaton}).
 */
public abstract class AutomatonException extends Exception {
  /**
   * A sesso de execuo onde o erro foi gerado.
   */
  private Session session;

  /**
   * Cria uma exceo com a sesso recebida.
   * 
   * @param session A sesso de execuo onde a exceo foi gerada.
   * 
   * @throws IllegalArgumentException Caso a sesso seja nula.
   */
  protected AutomatonException(Session session) {
    super();
    if (session == null) {
      throw new IllegalArgumentException("A sesso no pode ser nula (null).");
    }
    this.session = session;
  }

  /**
   * Cria uma exceo com a sesso e causa recebidas.
   * 
   * @param session A sesso de execuo onde a exceo foi gerada.
   * @param cause A causa da exceo.
   */
  protected AutomatonException(Session session, Throwable cause) {
    super(cause);
    this.session = session;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "Classe: " + this.getClass().getName() + " - Sesso: "
      + session.toString();
  }
}
