/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.parsers;

import java.util.Map;
import java.util.TreeMap;
import tecgraf.javautils.parsers.Session;
import tecgraf.javautils.parsers.Transition;
import tecgraf.javautils.parsers.actions.StateAction;
import tecgraf.javautils.parsers.actions.TransitionAction;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.exception.NoTransitionException;
import tecgraf.javautils.parsers.symbols.Symbol;

public class State {
    private Map<Symbol<?>, Transition> transitionMap;
    private Transition defaultTransition;
    private boolean isFinal;
    private StateAction enterAction;
    private StateAction exitAction;

    public State(boolean isFinal) {
        this.isFinal = isFinal;
        this.transitionMap = new TreeMap();
    }

    public State(boolean isFinal, StateAction enterAction) {
        this(isFinal);
        if (enterAction == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 permitida uma a\u00e7\u00e3o de entrada nula (null).");
        }
        this.enterAction = enterAction;
    }

    public State(boolean isFinal, StateAction enterAction, StateAction exitAction) {
        this(isFinal, enterAction);
        if (exitAction == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 permitida uma a\u00e7\u00e3o de sa\u00edda nula (null).");
        }
        this.exitAction = exitAction;
    }

    final void enter(Session session) throws AutomatonException {
        if (this.enterAction != null) {
            this.enterAction.execute(session);
        }
    }

    final void exit(Session session) throws AutomatonException {
        if (this.exitAction != null) {
            this.exitAction.execute(session);
        }
    }

    final State getNext(Symbol<?> symbol, Session session) throws NoTransitionException, AutomatonException {
        Transition transition = this.transitionMap.get(symbol);
        if (transition == null) {
            transition = this.defaultTransition;
        }
        if (transition == null) {
            throw new NoTransitionException(session, symbol, this);
        }
        return transition.execute(symbol, session);
    }

    public final void addTransition(Symbol<?> symbol, TransitionAction function, State target) {
        if (symbol == null) {
            throw new IllegalArgumentException("O s\u00edmbolo n\u00e3o pode ser nulo (null).");
        }
        this.addTransition(new Symbol[]{symbol}, function, target);
    }

    public final void addTransition(Symbol<?>[] symbols, TransitionAction function, State target) {
        if (symbols == null) {
            throw new IllegalArgumentException("O array de s\u00edmbolos n\u00e3o pode ser nulo (null).");
        }
        if (function == null) {
            throw new IllegalArgumentException("A fun\u00e7\u00e3o n\u00e3o pode ser nula (null).");
        }
        if (target == null) {
            throw new IllegalArgumentException("O estado-destino n\u00e3o pode ser nulo (null).");
        }
        Transition transition = new Transition(target, function);
        for (int i = 0; i < symbols.length; ++i) {
            this.transitionMap.put(symbols[i], transition);
        }
    }

    public final void setDefaultTransition(TransitionAction function, State target) {
        if (function == null) {
            throw new IllegalArgumentException("A fun\u00e7\u00e3o n\u00e3o pode ser nula (null).");
        }
        if (target == null) {
            throw new IllegalArgumentException("O estado-destino n\u00e3o pode ser nulo (null).");
        }
        this.defaultTransition = new Transition(target, function);
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    public final void setEnterAction(StateAction enterAction) {
        if (enterAction == null) {
            throw new IllegalArgumentException("A a\u00e7\u00e3o de entrada n\u00e3o pode ser nula (null).");
        }
        this.enterAction = enterAction;
    }

    public final void setExitAction(StateAction exitAction) {
        if (exitAction == null) {
            throw new IllegalArgumentException("A a\u00e7\u00e3o de sa\u00edda n\u00e3o pode ser nula (null).");
        }
        this.exitAction = exitAction;
    }
}

