/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.parsers.tsv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import tecgraf.javautils.parsers.FiniteAutomaton;
import tecgraf.javautils.parsers.Parser;
import tecgraf.javautils.parsers.State;
import tecgraf.javautils.parsers.Token;
import tecgraf.javautils.parsers.actions.AppendAction;
import tecgraf.javautils.parsers.actions.GenerateTokenAction;
import tecgraf.javautils.parsers.actions.TransitionAction;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.exception.MalformedInputException;
import tecgraf.javautils.parsers.iterators.CharSymbolIterator;
import tecgraf.javautils.parsers.symbols.CharSymbol;
import tecgraf.javautils.parsers.symbols.Symbol;

public final class TsvParser
extends Parser {
    public TsvParser() {
        super(new TsvFiniteAutomaton());
    }

    public String[][] parse(InputStream inStream, Charset charset) throws IOException, MalformedInputException {
        InputStreamReader reader = new InputStreamReader(inStream, charset);
        List<List<String>> lineList = this.createCsvRegisterList(reader);
        String[][] csvRegisterArray = this.toCsvRegisterArray(lineList);
        reader.close();
        return csvRegisterArray;
    }

    private List<List<String>> createCsvRegisterList(InputStreamReader reader) throws IOException, MalformedInputException {
        ArrayList<List<String>> lineList = new ArrayList<List<String>>();
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String line = lineNumberReader.readLine();
        while (line != null) {
            List<Token> tokens = null;
            try {
                tokens = this.parse(new CharSymbolIterator(line));
            }
            catch (AutomatonException e) {
                throw new MalformedInputException(lineNumberReader.getLineNumber(), (Throwable)e);
            }
            List<String> stringList = this.createStringList(tokens);
            lineList.add(stringList);
            line = lineNumberReader.readLine();
        }
        return lineList;
    }

    private List<String> createStringList(List<Token> tokens) {
        int size = tokens.size();
        ArrayList<String> stringList = new ArrayList<String>(size);
        for (Token token : tokens) {
            List<Symbol<?>> symbolList = token.getSymbolList();
            Iterator<Symbol<?>> symbolListIterator = symbolList.iterator();
            StringBuffer buffer = new StringBuffer();
            while (symbolListIterator.hasNext()) {
                CharSymbol symbol = (CharSymbol)symbolListIterator.next();
                Character obj = symbol.getObject();
                buffer.append(obj);
            }
            String string = buffer.toString();
            stringList.add(string);
        }
        return stringList;
    }

    private String[][] toCsvRegisterArray(List<List<String>> lineList) {
        int lineListSize = lineList.size();
        String[][] fieldMatrix = new String[lineListSize][];
        ListIterator<List<String>> lineListIterator = lineList.listIterator();
        int lineCounter = 0;
        while (lineListIterator.hasNext()) {
            List<String> fieldList = lineListIterator.next();
            fieldMatrix[lineCounter] = new String[fieldList.size()];
            ListIterator<String> fieldListIterator = fieldList.listIterator();
            int fieldCounter = 0;
            while (fieldListIterator.hasNext()) {
                String nextString;
                fieldMatrix[lineCounter][fieldCounter] = nextString = fieldListIterator.next();
                ++fieldCounter;
            }
            ++lineCounter;
        }
        return fieldMatrix;
    }

    private static class TsvFiniteAutomaton
    extends FiniteAutomaton {
        private static final CharSymbol SEPARATOR = new CharSymbol('\t');

        private TsvFiniteAutomaton() {
            super(new State(true));
            State initial = this.getInitialState();
            AppendAction appendAction = AppendAction.getInstance();
            initial.setDefaultTransition(appendAction, initial);
            GenerateTokenAction genTokenAction = GenerateTokenAction.getInstance();
            initial.addTransition(SEPARATOR, (TransitionAction)genTokenAction, initial);
        }
    }
}

