package tecgraf.javautils.pdfviewer.core;

import java.io.IOException;
import java.nio.ByteBuffer;

import tecgraf.javautils.pdfviewer.viewer.PDFViewerPanel;

import com.sun.pdfview.PDFFile;

/**
 * Classe que representa um documento PDF a ser visualizado pelo
 * {@link PDFViewerPanel} ou {@link PDFCorePanel}
 * 
 * @author Tecgraf
 */
public class PDFDocument {

  /**
   * Arquivo do documento PDF
   */
  private final PDFFile pdfFile;

  /**
   * Construtor package-visible para ser construido apenas pelo
   * {@link PDFReader}
   * 
   * @param byteBuffer buffer com o contedo do documento
   * @throws IOException
   */
  PDFDocument(ByteBuffer byteBuffer) throws IOException {
    pdfFile = new PDFFile(byteBuffer);
  }

  /**
   * Retorna o {@link PDFFile} do documento PDF, este mtodo deve ser
   * package-visible
   * 
   * @return o {@link PDFFile} do documento PDF
   */
  PDFFile getPDFFile() {
    return pdfFile;
  }

}
