package tecgraf.javautils.pdfviewer.core.actions;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.KeyStroke;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;

/**
 * Ao de zoom out.
 * 
 * @author Tecgraf
 */
public class PDFZoomOutAction extends PDFAbstractDocumentOpenAwareAction {
  /**
   * Construtor
   * 
   * @param pdfCorePanel painel bsico.
   */
  public PDFZoomOutAction(PDFCorePanel pdfCorePanel) {
    super(pdfCorePanel, PDFViewerImages.createImageIcon("zoom.out.16.gif"));
    final KeyStroke ks = KeyStroke.getKeyStroke(KeyEvent.VK_SUBTRACT, 0);
    putValue(Action.ACCELERATOR_KEY, ks);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    getPDFCorePanel().setZoom(getPDFCorePanel().getZoom() - 7);
  }
}
