package tecgraf.javautils.pdfviewer.core.listeners;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;

/**
 * Listener que  notificado quando um documento  aberto ou fechado
 * 
 * @author Tecgraf
 */
public interface PDFDocumentOpenCloseListener {
  /**
   * Indica que um documento PDF foi aberto
   * 
   * @param pdfCorePanel {@link PDFCorePanel} origem do evento
   */
  void documentOpened(PDFCorePanel pdfCorePanel);

  /**
   * Indica que um documento PDF foi fechado
   * 
   * @param source {@link PDFCorePanel} origem do evento
   */
  void documentClosed(PDFCorePanel source);

}
