package tecgraf.javautils.pdfviewer.viewer.actions;

import java.awt.event.ActionEvent;

import tecgraf.javautils.pdfviewer.core.PDFCorePanel;
import tecgraf.javautils.pdfviewer.core.actions.PDFAbstractDocumentOpenAwareAction;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerImages;
import tecgraf.javautils.pdfviewer.viewer.PDFViewerPanel;

/**
 * Ao que exibe ou oculta o sidebar das Thumbnails, deve ser adicionado como
 * ItemListener no JToggleButton para poder decidir se ir exibir ou ocultar o
 * sidebar de acordo com o estado do JToggleButton
 * 
 * @author Tecgraf
 */
public class PDFShowThumbnailsAction extends PDFAbstractDocumentOpenAwareAction {

  /** Viewer panel qual ter o estado da sidebar com os Thumbnails alterado */
  final private PDFViewerPanel pdfViewerPanel;

  /**
   * Construtor principal
   * 
   * @param pdfCorePanel
   * 
   * @param viewerPanel
   */
  public PDFShowThumbnailsAction(PDFCorePanel pdfCorePanel,
    PDFViewerPanel viewerPanel) {
    super(pdfCorePanel, PDFViewerImages
      .createImageIcon("show.thumbnails.16.png"));
    this.pdfViewerPanel = viewerPanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    boolean thumbsVisible = pdfViewerPanel.isThumbnailsVisible();
    pdfViewerPanel.setThumbnailsVisible(!thumbsVisible);
  }

}
