/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.pdfviewer.core;

import com.sun.pdfview.PDFPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

class PDFRendererPagePanel
extends JPanel {
    private final PDFImagePanel imagePanel = new PDFImagePanel();
    private PDFPage currentPage;
    private Dimension pageSize;
    private Dimension defaultPageSize;
    private double zoomPercentage;
    private LoadImageWorker lastImageLoader = null;

    PDFRendererPagePanel() {
        super(new BorderLayout());
        this.add((Component)this.imagePanel, "Center");
    }

    void showPage(PDFPage page) {
        this.currentPage = page;
        if (this.currentPage != null) {
            if (this.pageSize == null) {
                this.defaultPageSize = new Dimension((int)page.getPageBox().getWidth(), (int)page.getPageBox().getHeight());
                this.pageSize = new Dimension(this.defaultPageSize.width, this.defaultPageSize.height);
                this.zoomPercentage = 100.0;
            }
            this.loadCurrentPageWithCurrentPageSize();
        } else {
            this.pageSize = null;
            this.imagePanel.setImage(null);
        }
    }

    protected void loadCurrentPageWithCurrentPageSize() {
        if (this.lastImageLoader != null && !this.lastImageLoader.isDone()) {
            this.lastImageLoader.cancel(true);
        }
        if (this.pageSize.width > 0 && this.pageSize.height > 0) {
            this.lastImageLoader = new LoadImageWorker(this.pageSize);
            this.lastImageLoader.execute();
        }
    }

    protected void zoomByFactor(double zoomFactor) {
        this.pageSize.width = (int)((double)this.pageSize.width * zoomFactor);
        this.pageSize.height = (int)((double)this.pageSize.height * zoomFactor);
        this.zoomPercentage = 100.0 * (double)this.defaultPageSize.width / (double)this.pageSize.width;
        this.loadCurrentPageWithCurrentPageSize();
    }

    protected void setZoom(double percentage) {
        this.zoomPercentage = percentage;
        this.applyZoom();
    }

    protected void applyZoom() {
        double normalizedZoom = this.zoomPercentage / 100.0;
        this.pageSize.width = (int)((double)this.defaultPageSize.width * normalizedZoom);
        this.pageSize.height = (int)((double)this.defaultPageSize.height * normalizedZoom);
        this.loadCurrentPageWithCurrentPageSize();
    }

    protected double getZoom() {
        return this.zoomPercentage;
    }

    protected void setPageSize(Dimension pageSize) {
        this.zoomPercentage = 100.0 * (double)this.defaultPageSize.width / (double)pageSize.width;
        this.pageSize = pageSize;
    }

    protected Dimension getPageSize() {
        return this.pageSize;
    }

    Dimension getDefaultPageSize() {
        return this.defaultPageSize;
    }

    class LoadImageWorker
    extends SwingWorker<Image, Void> {
        final Dimension dimension;

        public LoadImageWorker(Dimension dimension) {
            this.dimension = dimension;
        }

        @Override
        protected Image doInBackground() throws Exception {
            return PDFRendererPagePanel.this.currentPage.getImage(this.dimension.width, this.dimension.height, null, null, true, true);
        }

        @Override
        protected void done() {
            try {
                PDFRendererPagePanel.this.imagePanel.setImage((Image)this.get());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PDFImagePanel
    extends JPanel {
        Image currentImage;
        int offsetX;
        int offsetY;

        PDFImagePanel() {
        }

        public void setImage(Image image) {
            if (this.currentImage != image) {
                this.currentImage = image;
                if (this.currentImage != null) {
                    this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
                } else {
                    this.setPreferredSize(new Dimension(1, 1));
                }
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.currentImage == null) {
                return;
            }
            int imageWidth = this.currentImage.getWidth(null);
            int imageHeight = this.currentImage.getHeight(null);
            this.offsetX = this.getSize().width > imageWidth ? (this.getSize().width - imageWidth) / 2 : 0;
            this.offsetY = this.getSize().height > imageHeight ? (this.getSize().height - imageHeight) / 2 : 0;
            g.drawImage(this.currentImage, this.offsetX, this.offsetY, this);
            g.drawLine(this.offsetX, this.offsetY, this.offsetX, this.offsetY + imageHeight);
            g.drawLine(this.offsetX, this.offsetY, this.offsetX + imageWidth, this.offsetY);
            g.drawLine(this.offsetX, this.offsetY + imageHeight, this.offsetX + imageWidth, this.offsetY + imageHeight);
            g.drawLine(this.offsetX + imageWidth, this.offsetY, this.offsetX + imageWidth, this.offsetY + imageHeight);
        }
    }
}

