/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.standard;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Route;
import spark.Service;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.core.JuIWebSocket;
import tecgraf.javautils.sparkserver.standard.JuRoute;
import tecgraf.javautils.sparkserver.standard.JuVerb;
import tecgraf.javautils.sparkserver.standard.JuWebSocketClass;
import tecgraf.javautils.sparkserver.utils.JuResponseUtilities;
import tecgraf.javautils.sparkserver.utils.JuStringUtilities;
import tecgraf.javautils.sparkserver.utils.JuSwaggerParser;

public class JuServer {
    private static JuServer instance;
    private final Service server;
    private final List<JuIController> controllers = new ArrayList<JuIController>();
    private final Logger logger = LoggerFactory.getLogger(JuServer.class);
    private String contactName;
    private String name;
    private String version;
    private String description;
    private String hostAddress;

    private JuServer() {
        this.server = Service.ignite();
        this.setPort(9999);
        this.setThreadsPool(5, 3, 3000);
    }

    public static JuServer getInstance() {
        if (instance == null) {
            instance = new JuServer();
        }
        return instance;
    }

    public void setThreadsPool(int maxThreads, int minThreads, int timeOutMillis) {
        this.server.threadPool(maxThreads, minThreads, timeOutMillis);
    }

    public void setPort(int port) {
        this.server.port(port);
    }

    public int getHostPort() {
        return this.server.port();
    }

    public void setExceptionHandler(Consumer<Exception> consumer) {
        this.server.initExceptionHandler(consumer);
    }

    public void stop() {
        this.server.stop();
    }

    public void start() throws Exception {
        try {
            this.controllers.forEach(c -> this.registerControllerWebSockets((JuIController)c));
            this.controllers.forEach(c -> this.registerControllerEndpoints((JuIController)c));
            this.registerSwagger();
            this.enableCORS();
        }
        catch (Throwable t) {
            this.server.stop();
            throw new Exception(t);
        }
        this.server.init();
        this.server.awaitInitialization();
    }

    public Stream<JuIController> getControllers() {
        return this.controllers.stream();
    }

    public void addController(JuIController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("null controller not allowed!");
        }
        this.controllers.add(controller);
    }

    private void enableCORS() {
        this.enableCORS("*", "*", "*");
    }

    private void enableCORS(String origin, String methods, String headers) {
        this.server.options("/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        this.server.before((request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        });
    }

    private void registerSwagger() throws Exception {
        try {
            String swaggerJson = JuSwaggerParser.getSwaggerJsonString(this);
            String path = "/swagger/";
            this.server.get("/swagger/", (req, res) -> JuResponseUtilities.setResponseAsJsonObject(res, 200, swaggerJson));
            this.logger.info("Swagger for ...");
        }
        catch (JsonProcessingException e) {
            throw new Exception(e);
        }
    }

    private void registerControllerEndpoints(JuIController controller) {
        Stream<JuIEndpoint> endpoints = controller.getEndpoints();
        endpoints.forEach(ed -> this.registerEndpoint(controller, (JuIEndpoint)ed));
    }

    private void registerControllerWebSockets(JuIController controller) {
        Stream<JuIWebSocket> websockets = controller.getWebSockets();
        websockets.forEach(ws -> this.registerWebSocket(controller, (JuIWebSocket)ws));
    }

    private void registerEndpoint(JuIController controller, JuIEndpoint endpoint) {
        JuRoute route = endpoint.getRoute();
        JuVerb verb = endpoint.getVerb();
        String path = JuStringUtilities.getRealPath(controller, endpoint.getPath());
        String fmt = "Register endpoint '%s' for controller '%s' at path '%s'";
        this.logger.info(String.format("Register endpoint '%s' for controller '%s' at path '%s'", endpoint.getName(), controller.getName(), path));
        switch (verb) {
            case GET: {
                this.server.get(path, (Route)route);
                return;
            }
            case PUT: {
                this.server.put(path, (Route)route);
                return;
            }
            case POST: {
                this.server.post(path, (Route)route);
                return;
            }
            case DELETE: {
                this.server.delete(path, (Route)route);
                return;
            }
        }
        throw new IllegalArgumentException("Verb not recognized!");
    }

    private void registerWebSocket(JuIController controller, JuIWebSocket websocket) {
        Class<? extends JuWebSocketClass> clazz = websocket.getWebSocketClass();
        String path = "/" + JuStringUtilities.getRealPath(controller, websocket.getPath());
        String fmt = "Register websocket '%s' for controller '%s' at path '%s'";
        this.logger.info(String.format("Register websocket '%s' for controller '%s' at path '%s'", websocket.getWebSocketClass().getName(), controller.getName(), path));
        this.server.webSocket(path, clazz);
    }

    public String getContactName() {
        return this.contactName;
    }

    public JuServer setContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public JuServer setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name == null ? this.getClass().getSimpleName() : this.name;
    }

    public JuServer setName(String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return this.version == null ? "V???.???.???" : this.version;
    }

    public JuServer setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getHostAddress() {
        return this.hostAddress == null ? "localhost" : this.hostAddress;
    }

    public JuServer setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
        return this;
    }
}

