/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Swagger;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.core.JuIController;
import tecgraf.javautils.sparkserver.standard.JuServer;
import tecgraf.javautils.sparkserver.utils.JuSwaggerReader;

public class JuSwaggerParser {
    private static final Logger logger = LoggerFactory.getLogger(JuSwaggerParser.class);

    public static String getSwaggerJsonString(JuServer server) throws JsonProcessingException {
        JuSwaggerReader reader = new JuSwaggerReader(server);
        Swagger swagger = reader.read();
        String json = JuSwaggerParser.swaggerToJson(swagger);
        return json;
    }

    public static String getSwaggerJson(JuIController controller) throws JsonProcessingException {
        String title = controller.getClass().getSimpleName().toLowerCase();
        Swagger swagger = JuSwaggerParser.getSwagger(controller);
        String json = JuSwaggerParser.swaggerToJson(swagger);
        return json;
    }

    public static Swagger getSwagger(JuIController controller) {
        Class<?> controllerClass = controller.getClass();
        String className = controllerClass.getSimpleName();
        logger.info("Search swagger for controller class: " + className);
        HashSet loadClasses = new HashSet();
        controller.getEndpoints().forEach(ep -> {
            Class<?> endpointClass = ep.getClass();
            loadClasses.add(endpointClass);
            logger.info("Search swagger for endpoint class: " + endpointClass);
        });
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle(className);
        beanConfig.setScan(true);
        beanConfig.setPrettyPrint(true);
        beanConfig.scanAndRead();
        beanConfig.setResourcePackage(controllerClass.getPackageName());
        Swagger swagger = beanConfig.getSwagger();
        Reader reader = new Reader(swagger);
        return reader.read(loadClasses);
    }

    public static String swaggerToJson(Swagger swagger) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String json = objectMapper.writeValueAsString((Object)swagger);
        return json;
    }
}

