/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.providers.ProviderDeleteAction;
import busexplorer.panel.providers.ProviderEditAction;
import busexplorer.panel.providers.ProviderRefreshAction;
import busexplorer.panel.providers.ProviderTableProvider;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ProviderMissingAuthorizations
extends ProviderRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public ProviderMissingAuthorizations(JFrame parentWindow) {
        super(parentWindow);
    }

    public ProviderMissingAuthorizations(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<ProviderWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new ProviderDeleteAction(this.parentWindow));
            actions.add(new ProviderEditAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent(new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new ProviderTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<ProviderWrapper>> task = new BusExplorerTask<List<ProviderWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                ArrayList<Provider> result = new ArrayList<Provider>();
                List providers = Application.login().extension.getProviders();
                for (Provider provider : providers) {
                    if (!provider.busquery().isEmpty() && provider.contracts().length > 0) {
                        ArrayList authorizedInterfaces = new ArrayList();
                        new BusQuery(provider.busquery()).filterAuthorizations().values().parallelStream().forEach(authorizedInterfaces::addAll);
                        for (Contract contract : provider.contracts()) {
                            if (authorizedInterfaces.containsAll(Arrays.asList(contract.interfaces()))) continue;
                            result.add(provider);
                            break;
                        }
                    }
                    this.setProgressStatus(100 * i / providers.size());
                    ++i;
                }
                this.setResult(ProviderWrapper.convertToInfo(result));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = ProviderMissingAuthorizations.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && ProviderMissingAuthorizations.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        ProviderMissingAuthorizations.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

