/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.providers;

import busexplorer.Application;
import busexplorer.desktop.dialog.ConsistencyValidationDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.logins.LoginWrapper;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;
import tecgraf.openbus.services.governance.v1_0.Integration;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ProviderDeleteAction
extends OpenBusAction<ProviderWrapper> {
    public ProviderDeleteAction(Window parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        List<ProviderWrapper> providers = this.getTablePanelComponent().getSelectedElements();
        Runnable delegateAfterTaskUI = this.getTablePanelComponent()::removeSelectedElements;
        ConsistencyValidationDialog.DeleteOptions removeFlags = new ConsistencyValidationDialog.DeleteOptions();
        ConsistencyValidationResult consistencyValidationResult = new ConsistencyValidationResult();
        BusExplorerTask<Void> deleteProviderTask = ProviderDeleteAction.DeleteProviderTask(providers, delegateAfterTaskUI, removeFlags, consistencyValidationResult);
        Runnable effectiveDeletion = () -> deleteProviderTask.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
        if (ProviderDeleteAction.ExecuteAllDependencyCheckTasks(this.parentWindow, providers, consistencyValidationResult)) {
            if (consistencyValidationResult.isEmpty()) {
                effectiveDeletion.run();
            } else {
                new ConsistencyValidationDialog(this.parentWindow, this.getString("confirm.title"), this.getClass(), consistencyValidationResult, removeFlags, effectiveDeletion).showDialog();
            }
        }
    }

    public static boolean ExecuteAllDependencyCheckTasks(Window parentWindow, Collection<ProviderWrapper> providers, ConsistencyValidationResult consistencyValidationResult) {
        String title = Language.get(ConsistencyValidationDialog.class, "waiting.dependency.title");
        String waitingMessage = Language.get(ProviderDeleteAction.class, "waiting.dependency.msg");
        BusExplorerTask<Void> extensionDependencyCheckTask = ProviderDeleteAction.ExtensionDependencyCheckTask(providers, consistencyValidationResult);
        BusExplorerTask<Void> governanceDependencyCheckTask = ProviderDeleteAction.GovernanceDependencyCheckTask(providers, consistencyValidationResult);
        extensionDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        governanceDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        return extensionDependencyCheckTask.getStatus() && governanceDependencyCheckTask.getStatus();
    }

    public static BusExplorerTask<Void> GovernanceDependencyCheckTask(final Collection<ProviderWrapper> providers, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                for (ProviderWrapper provider : providers) {
                    BusQuery busQuery = new BusQuery(provider.busquery());
                    for (ServiceOfferDesc serviceOfferDesc : busQuery.filterOffers()) {
                        consistencyValidationResult.getInconsistentOffers().add(new OfferWrapper(serviceOfferDesc));
                    }
                    for (RegisteredEntityDesc registeredEntityDesc : busQuery.filterEntities()) {
                        consistencyValidationResult.getInconsistentEntities().add(new EntityWrapper(registeredEntityDesc));
                        for (LoginInfo login : Application.login().admin.getLogins()) {
                            if (!login.entity.equals(registeredEntityDesc.id)) continue;
                            consistencyValidationResult.getInconsistentLogins().add(new LoginWrapper(login));
                        }
                    }
                    for (Map.Entry entry : busQuery.filterAuthorizations().entrySet()) {
                        ((List)entry.getValue()).forEach(iface -> consistencyValidationResult.getInconsistentAuthorizations().add(new AuthorizationWrapper((RegisteredEntityDesc)e.getKey(), (String)iface)));
                    }
                    this.setProgressStatus(100 * i / providers.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> ExtensionDependencyCheckTask(final Collection<ProviderWrapper> providers, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                for (ProviderWrapper provider : providers) {
                    String providerName = provider.remote().name();
                    for (Integration integration : Application.login().extension.getIntegrationRegistry().integrations()) {
                        Provider p = integration.provider();
                        if (p == null || !p.name().equals(providerName)) continue;
                        consistencyValidationResult.getInconsistentIntegrations().put(integration.id(), new IntegrationWrapper(integration));
                    }
                    this.setProgressStatus(100 * i / providers.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> DeleteProviderTask(final Collection<ProviderWrapper> providers, final Runnable delegateAfterTaskUI, final ConsistencyValidationDialog.DeleteOptions removeFlags, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                if (removeFlags.isFullyGovernanceRemoval()) {
                    for (Integer id : consistencyValidationResult.getInconsistentIntegrations().keySet()) {
                        Application.login().extension.getIntegrationRegistry().remove(id.intValue());
                    }
                }
                for (ProviderWrapper provider : providers) {
                    if (removeFlags.isFullyGovernanceRemoval()) {
                        BusQuery busQuery = new BusQuery(provider.busquery());
                        for (ServiceOfferDesc serviceOfferDesc : busQuery.filterOffers()) {
                            LoginInfo login = serviceOfferDesc.ref.owner();
                            Application.login().admin.invalidateLogin(login);
                            Application.login().admin.removeCertificate(login.entity);
                        }
                        for (Map.Entry entry : busQuery.filterAuthorizations().entrySet()) {
                            for (String iface : (List)entry.getValue()) {
                                ((RegisteredEntityDesc)entry.getKey()).ref.revokeInterface(iface);
                            }
                        }
                        for (RegisteredEntityDesc registeredEntityDesc : busQuery.filterEntities()) {
                            Application.login().admin.removeCertificate(registeredEntityDesc.id);
                            registeredEntityDesc.ref.remove();
                        }
                    }
                    Application.login().extension.getProviderRegistry().remove(provider.name());
                    this.setProgressStatus(100 * i / providers.size());
                    ++i;
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus() && delegateAfterTaskUI != null) {
                    delegateAfterTaskUI.run();
                }
            }
        };
    }
}

