package br.pucrio.tecgraf.soma.job.domain.model;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Job Algorithm Entity
 */
@Entity
@Table(name="job_algorithms")
public class JobAlgorithm implements Serializable {

    // The identifier
    @Id @GeneratedValue
    @Column(name="id")
    private Long id;

    // The algorithm identification
    @Column(name="algo_id", nullable=false)
    private String algorithmId;

    // The algorithm version
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;

    // The algorithm name
    @Column(name="algo_name", nullable=false)
    private String algorithmName;

    @ManyToOne
    @JoinColumn(name="job_id", nullable=false)
    private Job job;

    // The list of parameters used
    @OneToMany(mappedBy="jobAlgorithm", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval = true)
    @Fetch(value = FetchMode.SUBSELECT)
    private List<JobAlgorithmParameter> parameters = new ArrayList<JobAlgorithmParameter>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlgorithmId() {
        return algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlgorithmVersion() {
        return algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public Job getJob() {
        return job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public List<JobAlgorithmParameter> getParameters() {
        return parameters;
    }

    public void addParameter(JobAlgorithmParameter parameter) {
        parameter.setJobAlgorithm(this);
        this.parameters.add(parameter);
    }
}
