package br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl;

import com.github.tennaito.rsql.builder.BuilderTools;
import com.github.tennaito.rsql.jpa.AbstractJpaVisitor;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;

import javax.persistence.EntityManager;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSQLPredicateVisitor<T> extends AbstractJpaVisitor<Predicate, T> implements RSQLVisitor<Predicate, EntityManager> {
    /**
     * Logger.
     */
    private static final Logger LOG = Logger.getLogger(RSQLPredicateVisitor.class.getName());

    /**
     * Root.
     */
    private From root;

    public RSQLPredicateVisitor(T... t) {
        super(t);
        BuilderTools builderTools = getBuilderTools();
        builderTools.setArgumentParser(new ExtendedArgumentParser());
    }
    /**
     * Define the From node.
     * @param root From node that expressions path depends on.
     * @return Fluent interface.
     */
    public RSQLPredicateVisitor<T> defineRoot(From root) {
        this.root = root;
        return this;
    }

    public Predicate visit(AndNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for AndNode: {0}", node);
        return PredicateBuilder.<T>createPredicate(node, root, entityClass, entityManager, getBuilderTools());
    }
    public Predicate visit(OrNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for OrNode: {0}", node);
        return PredicateBuilder.<T>createPredicate(node, root, entityClass, entityManager, getBuilderTools());
    }
    public Predicate visit(ComparisonNode node, EntityManager entityManager) {
        LOG.log(Level.INFO, "Creating Predicate for ComparisonNode: {0}", node);
        return PredicateBuilder.<T>createPredicate(node, root, entityClass, entityManager, getBuilderTools());
    }
}
