package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.RSQLPredicateVisitor;
import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import cz.jirutka.rsql.parser.RSQLParser;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;

public class RSQLSpecification<T> extends JPASpecification<T> {

  private EntityManager entityManager;
  private String rsqlQuery;

  public RSQLSpecification(String rsqlQuery, EntityManager entityManager) {
    this.entityManager = entityManager;
    this.rsqlQuery = rsqlQuery;
  }

  protected RSQLParser buildRSQLParser() {
    return new RSQLParser();
  }

  public boolean isSatisfiedBy(T element) {
    throw new UnsupportedOperationException(
        "Missing implementation of isSatisfiedBy() on RSQLSpecification");
  }

  @SuppressWarnings("unchecked")
  @Override
  public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
    Node rsqlNode = buildRSQLParser().parse(rsqlQuery);
    RSQLVisitor<Predicate, EntityManager> visitor = new RSQLPredicateVisitor<T>().defineRoot(root);
    return rsqlNode.accept(visitor, entityManager);
  }

}
