package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.ExecutingJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

public class ExecutingJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobExecutingEvent event) {
    ExecutingJobMapper.getInstance().map(event, job);

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.EXECUTING, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }
}
