package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.FinishedJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

public class FinishedJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobFinishedEvent event) {
    FinishedJobMapper.getInstance().map(event, job);

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.FINISHED, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }
}
