package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.ParameterValueConverter;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithmParameter;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class JobAlgorithmParameterMapper {
  private static final String TYPE_MAP_NAME = "AlgorithmParameterToJobAlgorithmParameter";
  private static JobAlgorithmParameterMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<AlgorithmParameter, JobAlgorithmParameter> typeMap;

  private JobAlgorithmParameterMapper() {
    modelMapper = new ModelMapper();

    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap =
        modelMapper.createTypeMap(
            AlgorithmParameter.class, JobAlgorithmParameter.class, TYPE_MAP_NAME);

    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithmParameter::setId));
    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithmParameter::setJobAlgorithm));

    // TODO Adicionar ao ParameterValueConverter o parser do CSBase para o valor dos parâmetros
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new ParameterValueConverter())
                .map(AlgorithmParameter::getValue, JobAlgorithmParameter::setValue));

    modelMapper.validate();
  }

  public static JobAlgorithmParameterMapper getInstance() {
    if (instance == null) {
      instance = new JobAlgorithmParameterMapper();
    }
    return instance;
  }

  public void map(AlgorithmParameter parameter, JobAlgorithmParameter jobAlgorithm) {
    modelMapper.map(parameter, jobAlgorithm, TYPE_MAP_NAME);
  }
}
