/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import org.modelmapper.builder.ReferenceMapExpression;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.PropertyReferenceCollector;
import org.modelmapper.internal.ProxyFactory;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Primitives;
import org.modelmapper.spi.DestinationSetter;
import org.modelmapper.spi.SourceGetter;

class ReferenceMapExpressionImpl<S, D>
implements ReferenceMapExpression<S, D> {
    private TypeMapImpl<S, D> typeMap;
    private ExplicitMappingBuilder.MappingOptions options;

    ReferenceMapExpressionImpl(TypeMapImpl<S, D> typeMap) {
        this(typeMap, new ExplicitMappingBuilder.MappingOptions());
    }

    ReferenceMapExpressionImpl(TypeMapImpl<S, D> typeMap, ExplicitMappingBuilder.MappingOptions options) {
        this.typeMap = typeMap;
        this.options = options;
    }

    @Override
    public <V> void map(SourceGetter<S> sourceGetter, DestinationSetter<D, V> destinationSetter) {
        PropertyReferenceCollector collector = new PropertyReferenceCollector(this.typeMap.configuration, this.options);
        try {
            S source = ProxyFactory.proxyFor(this.typeMap.getSourceType(), collector.newSourceInterceptor(), collector.getProxyErrors());
            Object sourceProperty = sourceGetter.get(source);
            if (source == sourceProperty) {
                collector.mapFromSource(this.typeMap.getSourceType());
            }
            if (collector.isNoSourceGetter()) {
                collector.mapFromConstant(sourceProperty);
            }
        }
        catch (NullPointerException e) {
            if (collector.getProxyErrors().hasErrors()) {
                throw collector.getProxyErrors().toException();
            }
            throw e;
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
        try {
            D destination = ProxyFactory.proxyFor(this.typeMap.getDestinationType(), collector.newDestinationInterceptor(), collector.getProxyErrors());
            destinationSetter.accept(destination, this.destinationValue(destinationSetter));
        }
        catch (NullPointerException e) {
            if (collector.getProxyErrors().hasErrors()) {
                throw collector.getProxyErrors().toException();
            }
            throw e;
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
        this.typeMap.addMapping(collector.collect());
    }

    @Override
    public <V> void skip(DestinationSetter<D, V> destinationSetter) {
        this.options.skipType = 1;
        PropertyReferenceCollector collector = new PropertyReferenceCollector(this.typeMap.configuration, this.options);
        D destination = ProxyFactory.proxyFor(this.typeMap.getDestinationType(), collector.newDestinationInterceptor(), collector.getErrors());
        destinationSetter.accept(destination, this.destinationValue(destinationSetter));
        this.typeMap.addMapping(collector.collect());
    }

    private <V> V destinationValue(DestinationSetter<D, V> destinationSetter) {
        Class<?> valueClass;
        Class<?>[] typeArguments = TypeResolver.resolveRawArguments(DestinationSetter.class, destinationSetter.getClass());
        if (typeArguments != null && Primitives.isPrimitive(valueClass = typeArguments[1])) {
            return (V)Primitives.defaultValue(Primitives.primitiveFor(valueClass));
        }
        return null;
    }
}

