/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.admin;

import javax.management.MalformedObjectNameException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.admin.SpringApplicationAdminMXBeanRegistrar;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.jmx.export.MBeanExporter;

@Configuration
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.application.admin", value={"enabled"}, havingValue="true", matchIfMissing=false)
public class SpringApplicationAdminJmxAutoConfiguration {
    private static final String JMX_NAME_PROPERTY = "spring.application.admin.jmx-name";
    private static final String DEFAULT_JMX_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private final MBeanExporter mbeanExporter;
    private final Environment environment;

    public SpringApplicationAdminJmxAutoConfiguration(ObjectProvider<MBeanExporter> mbeanExporter, Environment environment2) {
        this.mbeanExporter = mbeanExporter.getIfAvailable();
        this.environment = environment2;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringApplicationAdminMXBeanRegistrar springApplicationAdminRegistrar() throws MalformedObjectNameException {
        String jmxName = this.environment.getProperty(JMX_NAME_PROPERTY, DEFAULT_JMX_NAME);
        if (this.mbeanExporter != null) {
            this.mbeanExporter.addExcludedBean(jmxName);
        }
        return new SpringApplicationAdminMXBeanRegistrar(jmxName);
    }
}

