/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.util.Assert;

public class SpringLobCreatorSynchronization
extends TransactionSynchronizationAdapter {
    public static final int LOB_CREATOR_SYNCHRONIZATION_ORDER = 800;
    private final LobCreator lobCreator;
    private boolean beforeCompletionCalled = false;

    public SpringLobCreatorSynchronization(LobCreator lobCreator) {
        Assert.notNull((Object)lobCreator, "LobCreator must not be null");
        this.lobCreator = lobCreator;
    }

    @Override
    public int getOrder() {
        return 800;
    }

    @Override
    public void beforeCompletion() {
        this.beforeCompletionCalled = true;
        this.lobCreator.close();
    }

    @Override
    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.lobCreator.close();
        }
    }
}

