/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.OptimisticLockException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.core.NamedThreadLocal;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate3.HibernateJdbcException;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate3.HibernateQueryException;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.orm.hibernate3.SpringSessionSynchronization;
import org.springframework.transaction.jta.SpringJtaSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

@Deprecated
public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    static final Log logger = LogFactory.getLog(SessionFactoryUtils.class);
    private static final ThreadLocal<Map<SessionFactory, Set<Session>>> deferredCloseHolder = new NamedThreadLocal<Map<SessionFactory, Set<Session>>>("Hibernate Sessions registered for deferred close");

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        ConnectionProvider cp;
        if (sessionFactory instanceof SessionFactoryImplementor && (cp = ((SessionFactoryImplementor)sessionFactory).getConnectionProvider()) instanceof LocalDataSourceConnectionProvider) {
            return ((LocalDataSourceConnectionProvider)cp).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SessionFactory sessionFactory) {
        DataSource ds = SessionFactoryUtils.getDataSource(sessionFactory);
        if (ds != null) {
            return new SQLErrorCodeSQLExceptionTranslator(ds);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SessionFactory sessionFactory, Session session) {
        SessionFactory internalFactory;
        SessionFactoryImplementor sessionFactoryImpl = null;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)sessionFactory;
        } else if (session != null && (internalFactory = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)internalFactory;
        }
        return sessionFactoryImpl != null ? sessionFactoryImpl.getTransactionManager() : null;
    }

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, null, null, allowCreate);
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        try {
            return SessionFactoryUtils.doGetSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, true);
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static Session doGetSession(SessionFactory sessionFactory, boolean allowCreate) throws HibernateException, IllegalStateException {
        return SessionFactoryUtils.doGetSession(sessionFactory, null, null, allowCreate);
    }

    private static Session doGetSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowCreate) throws HibernateException, IllegalStateException {
        Object session;
        Assert.notNull((Object)sessionFactory, "No SessionFactory specified");
        Object resource = TransactionSynchronizationManager.getResource(sessionFactory);
        if (resource instanceof Session) {
            return (Session)resource;
        }
        SessionHolder sessionHolder = (SessionHolder)resource;
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            session = null;
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                session = sessionHolder.getValidatedSession();
                if (session != null && !sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug("Registering Spring transaction synchronization for existing Hibernate Session");
                    TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                    FlushMode flushMode = session.getFlushMode();
                    if (flushMode.lessThan(FlushMode.COMMIT) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                        session.setFlushMode(FlushMode.AUTO);
                        sessionHolder.setPreviousFlushMode(flushMode);
                    }
                }
            } else {
                session = SessionFactoryUtils.getJtaSynchronizedSession(sessionHolder, sessionFactory, jdbcExceptionTranslator);
            }
            if (session != null) {
                return session;
            }
        }
        logger.debug("Opening Hibernate Session");
        Object object = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug("Registering Spring transaction synchronization for new Hibernate Session");
            SessionHolder holderToUse = sessionHolder;
            if (holderToUse == null) {
                holderToUse = new SessionHolder((Session)session);
            } else {
                holderToUse.addSession((Session)session);
            }
            if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                session.setFlushMode(FlushMode.MANUAL);
            }
            TransactionSynchronizationManager.registerSynchronization(new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true));
            holderToUse.setSynchronizedWithTransaction(true);
            if (holderToUse != sessionHolder) {
                TransactionSynchronizationManager.bindResource(sessionFactory, holderToUse);
            }
        } else {
            SessionFactoryUtils.registerJtaSynchronization((Session)session, sessionFactory, jdbcExceptionTranslator, sessionHolder);
        }
        if (!allowCreate && !SessionFactoryUtils.isSessionTransactional((Session)session, sessionFactory)) {
            SessionFactoryUtils.closeSession((Session)session);
            throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of non-transactional one here");
        }
        return session;
    }

    private static Session getJtaSynchronizedSession(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            try {
                int jtaStatus;
                Transaction jtaTx = jtaTm.getTransaction();
                if (jtaTx != null && ((jtaStatus = jtaTx.getStatus()) == 0 || jtaStatus == 1)) {
                    Session session = sessionHolder.getValidatedSession(jtaTx);
                    if (session == null && !sessionHolder.isSynchronizedWithTransaction() && (session = sessionHolder.getValidatedSession()) != null) {
                        logger.debug("Registering JTA transaction synchronization for existing Hibernate Session");
                        sessionHolder.addSession(jtaTx, session);
                        jtaTx.registerSynchronization(new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false), jtaTm));
                        sessionHolder.setSynchronizedWithTransaction(true);
                        FlushMode flushMode = session.getFlushMode();
                        if (flushMode.lessThan(FlushMode.COMMIT)) {
                            session.setFlushMode(FlushMode.AUTO);
                            sessionHolder.setPreviousFlushMode(flushMode);
                        }
                    }
                    return session;
                }
                return sessionHolder.getValidatedSession();
            }
            catch (Throwable ex) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", ex);
            }
        }
        return sessionHolder.getValidatedSession();
    }

    private static void registerJtaSynchronization(Session session, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, SessionHolder sessionHolder) {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
        if (jtaTm != null) {
            try {
                int jtaStatus;
                Transaction jtaTx = jtaTm.getTransaction();
                if (jtaTx != null && ((jtaStatus = jtaTx.getStatus()) == 0 || jtaStatus == 1)) {
                    logger.debug("Registering JTA transaction synchronization for new Hibernate Session");
                    SessionHolder holderToUse = sessionHolder;
                    if (holderToUse == null) {
                        holderToUse = new SessionHolder(jtaTx, session);
                    } else {
                        holderToUse.addSession(jtaTx, session);
                    }
                    jtaTx.registerSynchronization(new SpringJtaSynchronizationAdapter((TransactionSynchronization)new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                    holderToUse.setSynchronizedWithTransaction(true);
                    if (holderToUse != sessionHolder) {
                        TransactionSynchronizationManager.bindResource(sessionFactory, holderToUse);
                    }
                }
            }
            catch (Throwable ex) {
                throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", ex);
            }
        }
    }

    public static Session getNewSession(SessionFactory sessionFactory) {
        return SessionFactoryUtils.getNewSession(sessionFactory, null);
    }

    public static Session getNewSession(SessionFactory sessionFactory, Interceptor entityInterceptor) {
        Assert.notNull((Object)sessionFactory, "No SessionFactory specified");
        try {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
            if (sessionHolder != null && !sessionHolder.isEmpty()) {
                if (entityInterceptor != null) {
                    return sessionFactory.openSession(sessionHolder.getAnySession().connection(), entityInterceptor);
                }
                return sessionFactory.openSession(sessionHolder.getAnySession().connection());
            }
            if (entityInterceptor != null) {
                return sessionFactory.openSession(entityInterceptor);
            }
            return sessionFactory.openSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    public static String toString(Session session) {
        return session.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(session));
    }

    public static boolean hasTransactionalSession(SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        return sessionHolder != null && !sessionHolder.isEmpty();
    }

    public static boolean isSessionTransactional(Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder;
        Assert.notNull((Object)query, "No Query object specified");
        if (sessionFactory != null && (sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory)) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        SessionHolder sessionHolder;
        Assert.notNull((Object)criteria, "No Criteria object specified");
        if (sessionFactory != null && (sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory)) != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), ex);
        }
        if (ex instanceof SQLGrammarException) {
            SQLGrammarException jdbcEx = (SQLGrammarException)ex;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof org.hibernate.QueryTimeoutException) {
            org.hibernate.QueryTimeoutException jdbcEx = (org.hibernate.QueryTimeoutException)ex;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof LockAcquisitionException) {
            LockAcquisitionException jdbcEx = (LockAcquisitionException)ex;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof PessimisticLockException) {
            PessimisticLockException jdbcEx = (PessimisticLockException)ex;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof ConstraintViolationException) {
            ConstraintViolationException jdbcEx = (ConstraintViolationException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]; constraint [" + jdbcEx.getConstraintName() + "]", ex);
        }
        if (ex instanceof DataException) {
            DataException jdbcEx = (DataException)ex;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + jdbcEx.getSQL() + "]", ex);
        }
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, ex);
        }
        if (ex instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), ex);
        }
        if (ex instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof StaleStateException) {
            return new HibernateOptimisticLockingFailureException((StaleStateException)ex);
        }
        if (ex instanceof OptimisticLockException) {
            return new HibernateOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        return new HibernateSystemException(ex);
    }

    public static boolean isDeferredCloseActive(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, "No SessionFactory specified");
        Map<SessionFactory, Set<Session>> holderMap = deferredCloseHolder.get();
        return holderMap != null && holderMap.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, "No SessionFactory specified");
        logger.debug("Initializing deferred close of Hibernate Sessions");
        Map<SessionFactory, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap<SessionFactory, Set<Session>>();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(sessionFactory, new LinkedHashSet(4));
    }

    public static void processDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, "No SessionFactory specified");
        Map<SessionFactory, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SessionFactory [" + sessionFactory + "]");
        }
        logger.debug("Processing deferred close of Hibernate Sessions");
        Set<Session> sessions = holderMap.remove(sessionFactory);
        for (Session session : sessions) {
            SessionFactoryUtils.closeSession(session);
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.remove();
        }
    }

    public static void releaseSession(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
        }
    }

    static void closeSessionOrRegisterDeferredClose(Session session, SessionFactory sessionFactory) {
        Map<SessionFactory, Set<Session>> holderMap = deferredCloseHolder.get();
        if (holderMap != null && sessionFactory != null && holderMap.containsKey(sessionFactory)) {
            logger.debug("Registering Hibernate Session for deferred close");
            session.setFlushMode(FlushMode.MANUAL);
            Set<Session> sessions = holderMap.get(sessionFactory);
            sessions.add(session);
        } else {
            SessionFactoryUtils.closeSession(session);
        }
    }

    public static void closeSession(Session session) {
        if (session != null) {
            logger.debug("Closing Hibernate Session");
            try {
                session.close();
            }
            catch (HibernateException ex) {
                logger.debug("Could not close Hibernate Session", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing Hibernate Session", ex);
            }
        }
    }
}

