package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.application.service.LostEventService;
import br.pucrio.tecgraf.soma.job.application.service.KafkaOffsetInfoService;
import br.pucrio.tecgraf.soma.job.domain.model.LostEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;

@Service
public class LostEventAppService {

  private final Logger logger = LoggerFactory.getLogger(LostEventAppService.class);

  private LostEventService lostEventService;
  private KafkaOffsetInfoService kafkaOffsetInfoService;

  @Autowired
  public LostEventAppService(
      LostEventService lostEventService, KafkaOffsetInfoService kafkaOffsetInfoService) {
    this.lostEventService = lostEventService;
    this.kafkaOffsetInfoService = kafkaOffsetInfoService;
  }

  @Transactional(propagation = Propagation.REQUIRES_NEW)
  public void saveLostEvent(LostEvent event, int partitionId, long lastOffset) throws IOException {
    logger.info("Saving event [eventId={}] as lost event.");
    lostEventService.saveLostEvent(event);
    kafkaOffsetInfoService.updateOffsetInfo(partitionId, lastOffset);
  }
}
