package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.JobInitEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.InitJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;

public class InitJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobInitEvent event) {
    InitJobMapper.getInstance().map(event, job);

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.INIT, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }
}
