/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.Flow;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.SpecificationType;
import br.pucrio.tecgraf.soma.job.application.service.job.builder.AbstractJobBuilder;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithmParameter;
import br.pucrio.tecgraf.soma.job.domain.model.JobStatusHistory;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.JobAlgorithmMapper;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.JobAlgorithmParameterMapper;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.ScheduledJobMapper;
import java.util.Map;

public class ScheduledJobBuilder
extends AbstractJobBuilder {
    public void build(Job job, JobScheduledEvent event, Map<String, Job> dependencies) {
        this.build(job, event);
        for (Map.Entry<String, Job> dependency : dependencies.entrySet()) {
            job.addDependency(dependency.getKey(), dependency.getValue());
        }
    }

    public void build(Job job, JobScheduledEvent event) {
        ScheduledJobMapper.getInstance().map(event, job);
        if (event.getSpecificationType() == SpecificationType.ALGORITHM) {
            Algorithm algorithm = (Algorithm)event.getSpecification();
            JobAlgorithm jobAlgorithm = this.convertToJobAlgorithm(algorithm);
            job.addAlgorithm(jobAlgorithm);
        } else {
            Flow flow = (Flow)event.getSpecification();
            this.setFlowInfo(job, flow);
            for (Algorithm algorithm : flow.getAlgorithms()) {
                JobAlgorithm jobAlgorithm = this.convertToJobAlgorithm(algorithm);
                job.addAlgorithm(jobAlgorithm);
            }
        }
        JobStatusHistory jobStatusHistory = this.newJobStatusHistory(StatusType.SCHEDULED, event.getTimestamp().longValue());
        job.addStatusHistory(jobStatusHistory);
    }

    private void setFlowInfo(Job job, Flow flow) {
        job.setFlowId(flow.getFlowId().toString());
        job.setFlowName(flow.getFlowName().toString());
        job.setFlowVersion(flow.getFlowVersion().toString());
        job.setFlowRaw(flow.getRaw().array());
    }

    private JobAlgorithm convertToJobAlgorithm(Algorithm algorithm) {
        JobAlgorithm jobAlgorithm = new JobAlgorithm();
        JobAlgorithmMapper.getInstance().map(algorithm, jobAlgorithm);
        for (AlgorithmParameter algorithmParameter : algorithm.getParameters()) {
            JobAlgorithmParameter jobAlgorithmParameter = new JobAlgorithmParameter();
            JobAlgorithmParameterMapper.getInstance().map(algorithmParameter, jobAlgorithmParameter);
            jobAlgorithm.addParameter(jobAlgorithmParameter);
        }
        return jobAlgorithm;
    }
}

