package br.pucrio.tecgraf.soma.job.application.configuration;

import java.util.ArrayList;
import java.util.List;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ConfigurationOption;

public class Constants {

  public static final String JOB_SCHEDULED_EVENT = "JobScheduledEvent";
  public static final String JOB_RESCHEDULED_EVENT = "JobRescheduledEvent";
  public static final String JOB_STAGEIN_EVENT = "JobStageInEvent";
  public static final String JOB_STAGEOUT_EVENT = "JobStageOutEvent";
  public static final String JOB_EXECUTING_EVENT = "JobExecutingEvent";
  public static final String JOB_FINISHED_EVENT = "JobFinishedEvent";

  public enum Config {
    KAFKA_SERVER_ADDRESS(new ConfigurationOption('s', "server", "Kafka server address", true,
        "kafka:9092", 1, false, true, null))

    , KAFKA_SCHEMA_REGISTRY_URL(new ConfigurationOption('r', "schema-registry",
        "Kafka schema registry URL", true, "http://kafka:8081/", 1, false, true, null))

    , KAFKA_TOPIC(new ConfigurationOption('t', "topic", "Kafka topic", true, "/topic/job-events", 1,
        false, true, null))

    , KAFKA_CONSUMER_GROUP(new ConfigurationOption('g', "group", "Kafka consumer group (optional)",
        true, "aValidGroupName", 1, false, false, "job-history-group"))

    , WEBSOCKET_TOPIC_NAME(new ConfigurationOption('w', "websocketTopic",
        "Websocket Topic Name (optional)", true, "/job-info", 1, false, false, "/job-info"))

    , WEBSOCKET_PREFIX_TYPE(new ConfigurationOption('p', "websocketPrefixType",
        "Websocket Topic Prefix Type (optional). Use /queue for peer to peer communication or /topic when there are multiple subscribers",
        true, "/topic", 1, false, false, "/topic"))

    , WEBSOCKET_APPLICATION_PREFIX(new ConfigurationOption('a', "websocketApplicationPrefix",
        "Application destination name using which browser and server will communicate over WebSocket",
        true, "/soma-job-history-info", 1, false, false, "/soma-job-history-info"))

    , WEBSOCKET_ENDPOINT(
        new ConfigurationOption('e', "websocketEndpoint", "Websocket Topic Endpoint (optional)",
            true, "/job-history-info", 1, false, false, "/job-history-info"));

    public final ConfigurationOption option;

    private Config(ConfigurationOption configurationOption) {
      this.option = configurationOption;
    }

    public static List<ConfigurationOption> options() {
      List<ConfigurationOption> list = new ArrayList<>();
      for (Config config : values())
        list.add(config.option);
      return list;
    }

  }

}
