/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.configuration;

import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.JobEventVO;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class SocketHandler
extends TextWebSocketHandler {
    @Autowired
    private JobAppService jobAppService;
    private List<WebSocketSession> sessions = new CopyOnWriteArrayList();
    private Map<String, List<String>> projectsBySession = new ConcurrentHashMap();

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws InterruptedException, IOException {
        if (!session.isOpen()) {
            this.removeSession(session);
            return;
        }
        session.sendMessage((WebSocketMessage)message);
    }

    public void sendMessage(JobEventVO jobEvent) throws IOException, InterruptedException {
        for (WebSocketSession webSocketSession : this.sessions) {
            List projects;
            String sessionId = webSocketSession.getId();
            if (!this.projectsBySession.containsKey(sessionId) || !(projects = (List)this.projectsBySession.get(sessionId)).contains(jobEvent.getProjectId())) continue;
            this.handleTextMessage(webSocketSession, new TextMessage((CharSequence)jobEvent.toJson()));
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        URI sessionUri = session.getUri();
        String accessToken = sessionUri.getQuery();
        if (accessToken == null || accessToken.isEmpty()) {
            throw new AuthenticationCredentialsNotFoundException("Authorization token is required");
        }
        List projects = this.jobAppService.getUserProjects(accessToken);
        if (projects.isEmpty()) {
            throw new NotFoundException("User has access to no projects");
        }
        this.projectsBySession.put(session.getId(), projects);
        this.sessions.add(session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        this.removeSession(session);
    }

    private void removeSession(WebSocketSession session) {
        this.projectsBySession.remove(session.getId());
        this.sessions.remove(session);
    }
}

