/*
 * Job History Service
 * Job History Search API
 *
 * OpenAPI spec version: 1.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package br.pucrio.tecgraf.soma.job.api.model;

import java.util.Objects;
import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.StatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * JobView
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2019-10-29T21:32:27.952Z[Etc/UTC]")
public class JobView   {
  @JsonProperty("jobId")
  private String jobId;

  @JsonProperty("groupId")
  private String groupId;

  @JsonProperty("projectId")
  private String projectId;

  @JsonProperty("jobOwner")
  private String jobOwner;

  @JsonProperty("automaticallyMachineSelection")
  private Boolean automaticallyMachineSelection;

  @JsonProperty("selectedMachine")
  private String selectedMachine;

  @JsonProperty("numberOfProcesses")
  private Integer numberOfProcesses;

  @JsonProperty("numberOfProcessesByMachine")
  private Integer numberOfProcessesByMachine;

  @JsonProperty("submissionTime")
  private String submissionTime;

  @JsonProperty("description")
  private String description;

  @JsonProperty("priority")
  private Integer priority;

  @JsonProperty("multipleExecution")
  private Boolean multipleExecution;

  @JsonProperty("jobType")
  private JobType jobType = null;

  @JsonProperty("numberOfRetries")
  private Integer numberOfRetries;

  @JsonProperty("executionMachine")
  private String executionMachine;

  @JsonProperty("endTime")
  private String endTime;

  @JsonProperty("exitCode")
  private Integer exitCode;

  @JsonProperty("guiltyNodeId")
  private String guiltyNodeId;

  @JsonProperty("exitStatus")
  private ExitStatus exitStatus = null;

  @JsonProperty("cpuTime")
  private Double cpuTime;

  @JsonProperty("wallclockTime")
  private Integer wallclockTime;

  @JsonProperty("ramMemory")
  private Double ramMemory;

  @JsonProperty("flowId")
  private String flowId;

  @JsonProperty("flowVersion")
  private String flowVersion;

  @JsonProperty("flowName")
  private String flowName;

  @JsonProperty("lastModifiedTime")
  private String lastModifiedTime;

  @JsonProperty("jobStatus")
  private StatusType jobStatus = null;

  @JsonProperty("jobStatusTimestamp")
  private String jobStatusTimestamp;

  @JsonProperty("algorithmId")
  private String algorithmId;

  @JsonProperty("algorithmVersion")
  private String algorithmVersion = null;

  @JsonProperty("algorithmName")
  private String algorithmName = null;

  @JsonProperty("jobAlgoParamId")
  private BigDecimal jobAlgoParamId;

  @JsonProperty("parameterId")
  private String parameterId = null;

  @JsonProperty("paramLabel")
  private String paramLabel = null;

  @JsonProperty("paramType")
  private String paramType = null;

  @JsonProperty("paramValue")
  private String paramValue = null;

  public JobView jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The job Id.
   * @return jobId
   **/
  @JsonProperty("jobId")
  @ApiModelProperty(value = "The job Id.")
  
  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public JobView groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * The group Id of the job.
   * @return groupId
   **/
  @JsonProperty("groupId")
  @ApiModelProperty(value = "The group Id of the job.")
  
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public JobView projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The project Id associated with the job.
   * @return projectId
   **/
  @JsonProperty("projectId")
  @ApiModelProperty(value = "The project Id associated with the job.")
  
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public JobView jobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
    return this;
  }

  /**
   * The id of the user who submitted the job.
   * @return jobOwner
   **/
  @JsonProperty("jobOwner")
  @ApiModelProperty(value = "The id of the user who submitted the job.")
  
  public String getJobOwner() {
    return jobOwner;
  }

  public void setJobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
  }

  public JobView automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
    return this;
  }

  /**
   * If the user select a machine for execution or not.
   * @return automaticallyMachineSelection
   **/
  @JsonProperty("automaticallyMachineSelection")
  @ApiModelProperty(value = "If the user select a machine for execution or not.")
  
  public Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
  }

  public JobView selectedMachine(String selectedMachine) {
    this.selectedMachine = selectedMachine;
    return this;
  }

  /**
   * The selected machines for job execution. If the user choose the automatically machine selection, this information is empty. (submissionMachines)
   * @return selectedMachine
   **/
  @JsonProperty("selectedMachine")
  @ApiModelProperty(value = "The selected machines for job execution. If the user choose the automatically machine selection, this information is empty. (submissionMachines)")
  
  public String getSelectedMachine() {
    return selectedMachine;
  }

  public void setSelectedMachine(String selectedMachine) {
    this.selectedMachine = selectedMachine;
  }

  public JobView numberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
    return this;
  }

  /**
   * The total number of job processes. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcesses
   **/
  @JsonProperty("numberOfProcesses")
  @ApiModelProperty(value = "The total number of job processes. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcesses() {
    return numberOfProcesses;
  }

  public void setNumberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
  }

  public JobView numberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    return this;
  }

  /**
   * The number of job processes by machine. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcessesByMachine
   **/
  @JsonProperty("numberOfProcessesByMachine")
  @ApiModelProperty(value = "The number of job processes by machine. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcessesByMachine() {
    return numberOfProcessesByMachine;
  }

  public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
  }

  public JobView submissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
    return this;
  }

  /**
   * The submission time.
   * @return submissionTime
   **/
  @JsonProperty("submissionTime")
  @ApiModelProperty(value = "The submission time.")
  
  public String getSubmissionTime() {
    return submissionTime;
  }

  public void setSubmissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
  }

  public JobView description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description provided by the user at submission. It can be empty.
   * @return description
   **/
  @JsonProperty("description")
  @ApiModelProperty(value = "The description provided by the user at submission. It can be empty.")
  
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public JobView priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the job.
   * @return priority
   **/
  @JsonProperty("priority")
  @ApiModelProperty(value = "The priority of the job.")
  
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public JobView multipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
    return this;
  }

  /**
   * If the user requested a multiple execution.
   * @return multipleExecution
   **/
  @JsonProperty("multipleExecution")
  @ApiModelProperty(value = "If the user requested a multiple execution.")
  
  public Boolean getMultipleExecution() {
    return multipleExecution;
  }

  public void setMultipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
  }

  public JobView jobType(JobType jobType) {
    this.jobType = jobType;
    return this;
  }

  /**
   * Get jobType
   * @return jobType
   **/
  @JsonProperty("jobType")
  @ApiModelProperty(value = "")
  @Valid
  public JobType getJobType() {
    return jobType;
  }

  public void setJobType(JobType jobType) {
    this.jobType = jobType;
  }

  public JobView numberOfRetries(Integer numberOfRetries) {
    this.numberOfRetries = numberOfRetries;
    return this;
  }

  /**
   * The number of times the job has already been scheduled for execution (numberOfAttempts).
   * @return numberOfRetries
   **/
  @JsonProperty("numberOfRetries")
  @ApiModelProperty(value = "The number of times the job has already been scheduled for execution (numberOfAttempts).")
  
  public Integer getNumberOfRetries() {
    return numberOfRetries;
  }

  public void setNumberOfRetries(Integer numberOfRetries) {
    this.numberOfRetries = numberOfRetries;
  }

  public JobView executionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
    return this;
  }

  /**
   * The machine where the job executed (or was scheduled to execute).
   * @return executionMachine
   **/
  @JsonProperty("executionMachine")
  @ApiModelProperty(value = "The machine where the job executed (or was scheduled to execute).")
  
  public String getExecutionMachine() {
    return executionMachine;
  }

  public void setExecutionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
  }

  public JobView endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The end time of the execution. It can be empty if the job have not already finished.
   * @return endTime
   **/
  @JsonProperty("endTime")
  @ApiModelProperty(value = "The end time of the execution. It can be empty if the job have not already finished.")
  
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public JobView exitCode(Integer exitCode) {
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.
   * @return exitCode
   **/
  @JsonProperty("exitCode")
  @ApiModelProperty(value = "The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
  
  public Integer getExitCode() {
    return exitCode;
  }

  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }

  public JobView guiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
    return this;
  }

  /**
   * The id of the algorithm of the flow that caused the job to finish earlier than expected.
   * @return guiltyNodeId
   **/
  @JsonProperty("guiltyNodeId")
  @ApiModelProperty(value = "The id of the algorithm of the flow that caused the job to finish earlier than expected.")
  
  public String getGuiltyNodeId() {
    return guiltyNodeId;
  }

  public void setGuiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
  }

  public JobView exitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
    return this;
  }

  /**
   * Get exitStatus
   * @return exitStatus
   **/
  @JsonProperty("exitStatus")
  @ApiModelProperty(value = "")
  @Valid
  public ExitStatus getExitStatus() {
    return exitStatus;
  }

  public void setExitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
  }

  public JobView cpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
    return this;
  }

  /**
   * Get cpuTime
   * @return cpuTime
   **/
  @JsonProperty("cpuTime")
  @ApiModelProperty(value = "")
  
  public Double getCpuTime() {
    return cpuTime;
  }

  public void setCpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
  }

  public JobView wallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
    return this;
  }

  /**
   * Get wallclockTime
   * @return wallclockTime
   **/
  @JsonProperty("wallclockTime")
  @ApiModelProperty(value = "")
  
  public Integer getWallclockTime() {
    return wallclockTime;
  }

  public void setWallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
  }

  public JobView ramMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
    return this;
  }

  /**
   * Get ramMemory
   * @return ramMemory
   **/
  @JsonProperty("ramMemory")
  @ApiModelProperty(value = "")
  
  public Double getRamMemory() {
    return ramMemory;
  }

  public void setRamMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
  }

  public JobView flowId(String flowId) {
    this.flowId = flowId;
    return this;
  }

  /**
   * The flow id associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowId
   **/
  @JsonProperty("flowId")
  @ApiModelProperty(value = "The flow id associated with the job (if jobType == FLOW).")
  
  public String getFlowId() {
    return flowId;
  }

  public void setFlowId(String flowId) {
    this.flowId = flowId;
  }

  public JobView flowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
    return this;
  }

  /**
   * The flow version associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowVersion
   **/
  @JsonProperty("flowVersion")
  @ApiModelProperty(value = "The flow version associated with the job (if jobType == FLOW).")
  
  public String getFlowVersion() {
    return flowVersion;
  }

  public void setFlowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
  }

  public JobView flowName(String flowName) {
    this.flowName = flowName;
    return this;
  }

  /**
   * The flow name associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowName
   **/
  @JsonProperty("flowName")
  @ApiModelProperty(value = "The flow name associated with the job (if jobType == FLOW).")
  
  public String getFlowName() {
    return flowName;
  }

  public void setFlowName(String flowName) {
    this.flowName = flowName;
  }

  public JobView lastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The time of job last modification.
   * @return lastModifiedTime
   **/
  @JsonProperty("lastModifiedTime")
  @ApiModelProperty(value = "The time of job last modification.")
  
  public String getLastModifiedTime() {
    return lastModifiedTime;
  }

  public void setLastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
  }

  public JobView jobStatus(StatusType jobStatus) {
    this.jobStatus = jobStatus;
    return this;
  }

  /**
   * Get jobStatus
   * @return jobStatus
   **/
  @JsonProperty("jobStatus")
  @ApiModelProperty(value = "")
  @Valid
  public StatusType getJobStatus() {
    return jobStatus;
  }

  public void setJobStatus(StatusType jobStatus) {
    this.jobStatus = jobStatus;
  }

  public JobView jobStatusTimestamp(String jobStatusTimestamp) {
    this.jobStatusTimestamp = jobStatusTimestamp;
    return this;
  }

  /**
   * Get jobStatusTimestamp
   * @return jobStatusTimestamp
   **/
  @JsonProperty("jobStatusTimestamp")
  @ApiModelProperty(value = "")
  
  public String getJobStatusTimestamp() {
    return jobStatusTimestamp;
  }

  public void setJobStatusTimestamp(String jobStatusTimestamp) {
    this.jobStatusTimestamp = jobStatusTimestamp;
  }

  public JobView algorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
    return this;
  }

  /**
   * The algorithm identification
   * @return algorithmId
   **/
  @JsonProperty("algorithmId")
  @ApiModelProperty(value = "The algorithm identification")
  
  public String getAlgorithmId() {
    return algorithmId;
  }

  public void setAlgorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
  }

  public JobView algorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
    return this;
  }

  /**
   * The algorithm version
   * @return algorithmVersion
   **/
  @JsonProperty("algorithmVersion")
  @ApiModelProperty(value = "The algorithm version")
  
  public String getAlgorithmVersion() {
    return algorithmVersion;
  }

  public void setAlgorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
  }

  public JobView algorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
    return this;
  }

  /**
   * The algorithm name
   * @return algorithmName
   **/
  @JsonProperty("algorithmName")
  @ApiModelProperty(value = "The algorithm name")
  
  public String getAlgorithmName() {
    return algorithmName;
  }

  public void setAlgorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
  }

  public JobView jobAlgoParamId(BigDecimal jobAlgoParamId) {
    this.jobAlgoParamId = jobAlgoParamId;
    return this;
  }

  /**
   * The job&#39;s algorithms parameter id.
   * @return jobAlgoParamId
   **/
  @JsonProperty("jobAlgoParamId")
  @ApiModelProperty(value = "The job's algorithms parameter id.")
  @Valid
  public BigDecimal getJobAlgoParamId() {
    return jobAlgoParamId;
  }

  public void setJobAlgoParamId(BigDecimal jobAlgoParamId) {
    this.jobAlgoParamId = jobAlgoParamId;
  }

  public JobView parameterId(String parameterId) {
    this.parameterId = parameterId;
    return this;
  }

  /**
   * The parameter name
   * @return parameterId
   **/
  @JsonProperty("parameterId")
  @ApiModelProperty(value = "The parameter name")
  
  public String getParameterId() {
    return parameterId;
  }

  public void setParameterId(String parameterId) {
    this.parameterId = parameterId;
  }

  public JobView paramLabel(String paramLabel) {
    this.paramLabel = paramLabel;
    return this;
  }

  /**
   * Parameter label
   * @return paramLabel
   **/
  @JsonProperty("paramLabel")
  @ApiModelProperty(value = "Parameter label")
  
  public String getParamLabel() {
    return paramLabel;
  }

  public void setParamLabel(String paramLabel) {
    this.paramLabel = paramLabel;
  }

  public JobView paramType(String paramType) {
    this.paramType = paramType;
    return this;
  }

  /**
   * The type of the parameter
   * @return paramType
   **/
  @JsonProperty("paramType")
  @ApiModelProperty(value = "The type of the parameter")
  
  public String getParamType() {
    return paramType;
  }

  public void setParamType(String paramType) {
    this.paramType = paramType;
  }

  public JobView paramValue(String paramValue) {
    this.paramValue = paramValue;
    return this;
  }

  /**
   * Job parameter value
   * @return paramValue
   **/
  @JsonProperty("paramValue")
  @ApiModelProperty(value = "Job parameter value")
  
  public String getParamValue() {
    return paramValue;
  }

  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobView jobView = (JobView) o;
    return Objects.equals(this.jobId, jobView.jobId) &&
        Objects.equals(this.groupId, jobView.groupId) &&
        Objects.equals(this.projectId, jobView.projectId) &&
        Objects.equals(this.jobOwner, jobView.jobOwner) &&
        Objects.equals(this.automaticallyMachineSelection, jobView.automaticallyMachineSelection) &&
        Objects.equals(this.selectedMachine, jobView.selectedMachine) &&
        Objects.equals(this.numberOfProcesses, jobView.numberOfProcesses) &&
        Objects.equals(this.numberOfProcessesByMachine, jobView.numberOfProcessesByMachine) &&
        Objects.equals(this.submissionTime, jobView.submissionTime) &&
        Objects.equals(this.description, jobView.description) &&
        Objects.equals(this.priority, jobView.priority) &&
        Objects.equals(this.multipleExecution, jobView.multipleExecution) &&
        Objects.equals(this.jobType, jobView.jobType) &&
        Objects.equals(this.numberOfRetries, jobView.numberOfRetries) &&
        Objects.equals(this.executionMachine, jobView.executionMachine) &&
        Objects.equals(this.endTime, jobView.endTime) &&
        Objects.equals(this.exitCode, jobView.exitCode) &&
        Objects.equals(this.guiltyNodeId, jobView.guiltyNodeId) &&
        Objects.equals(this.exitStatus, jobView.exitStatus) &&
        Objects.equals(this.cpuTime, jobView.cpuTime) &&
        Objects.equals(this.wallclockTime, jobView.wallclockTime) &&
        Objects.equals(this.ramMemory, jobView.ramMemory) &&
        Objects.equals(this.flowId, jobView.flowId) &&
        Objects.equals(this.flowVersion, jobView.flowVersion) &&
        Objects.equals(this.flowName, jobView.flowName) &&
        Objects.equals(this.lastModifiedTime, jobView.lastModifiedTime) &&
        Objects.equals(this.jobStatus, jobView.jobStatus) &&
        Objects.equals(this.jobStatusTimestamp, jobView.jobStatusTimestamp) &&
        Objects.equals(this.algorithmId, jobView.algorithmId) &&
        Objects.equals(this.algorithmVersion, jobView.algorithmVersion) &&
        Objects.equals(this.algorithmName, jobView.algorithmName) &&
        Objects.equals(this.jobAlgoParamId, jobView.jobAlgoParamId) &&
        Objects.equals(this.parameterId, jobView.parameterId) &&
        Objects.equals(this.paramLabel, jobView.paramLabel) &&
        Objects.equals(this.paramType, jobView.paramType) &&
        Objects.equals(this.paramValue, jobView.paramValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobId, groupId, projectId, jobOwner, automaticallyMachineSelection, selectedMachine, numberOfProcesses, numberOfProcessesByMachine, submissionTime, description, priority, multipleExecution, jobType, numberOfRetries, executionMachine, endTime, exitCode, guiltyNodeId, exitStatus, cpuTime, wallclockTime, ramMemory, flowId, flowVersion, flowName, lastModifiedTime, jobStatus, jobStatusTimestamp, algorithmId, algorithmVersion, algorithmName, jobAlgoParamId, parameterId, paramLabel, paramType, paramValue);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobView {\n");
    
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    jobOwner: ").append(toIndentedString(jobOwner)).append("\n");
    sb.append("    automaticallyMachineSelection: ").append(toIndentedString(automaticallyMachineSelection)).append("\n");
    sb.append("    selectedMachine: ").append(toIndentedString(selectedMachine)).append("\n");
    sb.append("    numberOfProcesses: ").append(toIndentedString(numberOfProcesses)).append("\n");
    sb.append("    numberOfProcessesByMachine: ").append(toIndentedString(numberOfProcessesByMachine)).append("\n");
    sb.append("    submissionTime: ").append(toIndentedString(submissionTime)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    multipleExecution: ").append(toIndentedString(multipleExecution)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    numberOfRetries: ").append(toIndentedString(numberOfRetries)).append("\n");
    sb.append("    executionMachine: ").append(toIndentedString(executionMachine)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    guiltyNodeId: ").append(toIndentedString(guiltyNodeId)).append("\n");
    sb.append("    exitStatus: ").append(toIndentedString(exitStatus)).append("\n");
    sb.append("    cpuTime: ").append(toIndentedString(cpuTime)).append("\n");
    sb.append("    wallclockTime: ").append(toIndentedString(wallclockTime)).append("\n");
    sb.append("    ramMemory: ").append(toIndentedString(ramMemory)).append("\n");
    sb.append("    flowId: ").append(toIndentedString(flowId)).append("\n");
    sb.append("    flowVersion: ").append(toIndentedString(flowVersion)).append("\n");
    sb.append("    flowName: ").append(toIndentedString(flowName)).append("\n");
    sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
    sb.append("    jobStatus: ").append(toIndentedString(jobStatus)).append("\n");
    sb.append("    jobStatusTimestamp: ").append(toIndentedString(jobStatusTimestamp)).append("\n");
    sb.append("    algorithmId: ").append(toIndentedString(algorithmId)).append("\n");
    sb.append("    algorithmVersion: ").append(toIndentedString(algorithmVersion)).append("\n");
    sb.append("    algorithmName: ").append(toIndentedString(algorithmName)).append("\n");
    sb.append("    jobAlgoParamId: ").append(toIndentedString(jobAlgoParamId)).append("\n");
    sb.append("    parameterId: ").append(toIndentedString(parameterId)).append("\n");
    sb.append("    paramLabel: ").append(toIndentedString(paramLabel)).append("\n");
    sb.append("    paramType: ").append(toIndentedString(paramType)).append("\n");
    sb.append("    paramValue: ").append(toIndentedString(paramValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

