/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobView;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobAppService {
    @Autowired
    JobService service;
    @Autowired
    private ServiceConfiguration config;

    @Transactional
    public void markJobAsDeleted(String jobId) {
        this.service.markJobAsDeleted(jobId);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        this.service.markJobsAsDeleted(jobIds);
    }

    @Transactional
    public Tuple<List<Job>, Integer> findJobs(String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
        List jobs = this.service.findJobs(rsqlQuery, offset, limit, ascending, sortAttribute);
        int total = (int)this.service.count(rsqlQuery);
        return new Tuple((Object)jobs, (Object)total);
    }

    @Transactional
    public Tuple<List<JobView>, Integer> findJobsFromView(String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
        List jobs = this.service.findJobsFromView(rsqlQuery, offset, limit, ascending, sortAttribute);
        int total = (int)this.service.countFromView(rsqlQuery);
        return new Tuple((Object)jobs, (Object)total);
    }

    public List<String> getUserProjects(String locale, String accessToken) throws NotFoundException {
        String csgridBaseURL = this.config.getValue(Constants.Config.CSGRID_BASE_URL.option.getLongName());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(csgridBaseURL);
        Invocation.Builder requestBuilder = target.path("projects").path("permissions").queryParam("locale", new Object[]{locale}).request(new String[]{"application/json"}).header("Authorization", (Object)accessToken);
        Response response = requestBuilder.get();
        if (response.getStatus() != 200) {
            throw new NotFoundException(response.getStatus(), "Error while trying to retrieve user projects: " + response.getEntity());
        }
        return (List)response.readEntity((GenericType)new /* Unavailable Anonymous Inner Class!! */);
    }

    public JobPagination buildPaginationInfo(Integer total, Integer offset, Integer limit) {
        JobPagination pagination = new JobPagination();
        pagination.total(total);
        pagination.limit(limit);
        if (offset == null) {
            pagination.offset(Integer.valueOf(0));
        } else {
            int newOffset = offset >= total ? (total == 0 ? 0 : (total % limit == 0 ? total - limit : total - total % limit)) : offset;
            pagination.offset(Integer.valueOf(newOffset));
        }
        return pagination;
    }
}

