/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.application.service.MultiflowService;
import br.pucrio.tecgraf.soma.job.application.service.ProjectService;
import br.pucrio.tecgraf.soma.job.application.service.ReplicaService;
import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import javax.ws.rs.ForbiddenException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReplicaAppService {
    @Autowired
    private ProjectService projectService;
    @Autowired
    private MultiflowService multiflowService;
    @Autowired
    private ReplicaService replicaService;

    @Transactional
    public Long createReplicaJob(br.pucrio.tecgraf.soma.job.api.model.ReplicaJob replicaJobData) {
        Multiflow multiflow = this.multiflowService.findMultiflowById(replicaJobData.getMultiflowId());
        if (!this.projectService.hasPermission(multiflow.getProjectId())) {
            throw new ForbiddenException("User has no permission to add a Replica to this project");
        }
        Replica replica = this.replicaService.findReplicaBy(multiflow.getId(), replicaJobData.getLineNumber().intValue());
        if (replica == null) {
            replica = new Replica();
            replica.setMultiflow(multiflow);
            replica.setLineNumber(replicaJobData.getLineNumber());
            this.replicaService.createReplica(replica);
        }
        ReplicaJob replicaJob = new ReplicaJob();
        replicaJob.setJobStringId(replicaJobData.getJobId());
        replicaJob.setSubmissionTime(LocalDateTime.now(ZoneOffset.UTC));
        replica.addReplicaJob(replicaJob);
        this.replicaService.updateReplica(replica);
        return replica.getId();
    }
}

