package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.ReplicaApiService;
import br.pucrio.tecgraf.soma.job.api.factories.ReplicaApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobResponse;

import java.util.Map;
import java.util.List;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/replica")


@io.swagger.annotations.Api(description = "the replica API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2023-09-08T13:35:35.875Z[Etc/UTC]")
public class ReplicaApi  {
   private final ReplicaApiService delegate;

   public ReplicaApi(@Context ServletConfig servletContext) {
      ReplicaApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("ReplicaApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (ReplicaApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         }
      }

      if (delegate == null) {
         delegate = ReplicaApiServiceFactory.getReplicaApi();
      }

      this.delegate = delegate;
   }

    @javax.ws.rs.POST
    
    @Consumes({ "application/json" })
    @Produces({ "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Create a replica submission", notes = "This endpoint creates a replica submission from a multiflow.", response = ReplicaJobResponse.class, tags={ "Replicas", })
    @io.swagger.annotations.ApiResponses(value = {
        @io.swagger.annotations.ApiResponse(code = 201, message = "New replica job created.", response = ReplicaJobResponse.class),
        @io.swagger.annotations.ApiResponse(code = 400, message = "Missing body parameter(s).", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 401, message = "No authorization token.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 403, message = "The authenticated user does not have permission to access the project.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 404, message = "Multiflow not found.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 409, message = "Job id already associated with a replica.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the multiflow creation.", response = Void.class),
        @io.swagger.annotations.ApiResponse(code = 503, message = "Server is currently unable to handle the request.", response = Void.class)
    })
    public Response replicaPost(@ApiParam(value = "Required information to create a replica submission", required = true) @NotNull @Valid  ReplicaJob replicaJob,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale")  String locale,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.replicaPost(replicaJob, locale, securityContext);
    }
}
