/*
 * Job History Service
 * Job History Search API
 *
 * The version of the OpenAPI document: 1.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package br.pucrio.tecgraf.soma.job.api.model;

import java.util.Objects;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmParameter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * JobAlgorithm
 */
@JsonPropertyOrder({
  JobAlgorithm.JSON_PROPERTY_ALGORITHM_ID,
  JobAlgorithm.JSON_PROPERTY_ALGORITHM_VERSION,
  JobAlgorithm.JSON_PROPERTY_ALGORITHM_NAME,
  JobAlgorithm.JSON_PROPERTY_FLOW_NODE_ID,
  JobAlgorithm.JSON_PROPERTY_PARAMETERS
})
@com.fasterxml.jackson.annotation.JsonInclude(value=com.fasterxml.jackson.annotation.JsonInclude.Include.CUSTOM,valueFilter=br.pucrio.tecgraf.soma.job.application.JsonUndefined.class)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2020-11-06T16:46:24.800Z[Etc/UTC]")
public class JobAlgorithm   {
  public static final String JSON_PROPERTY_ALGORITHM_ID = "algorithmId";
  @JsonProperty(JSON_PROPERTY_ALGORITHM_ID)
  private String algorithmId;

  public static final String JSON_PROPERTY_ALGORITHM_VERSION = "algorithmVersion";
  @JsonProperty(JSON_PROPERTY_ALGORITHM_VERSION)
  private String algorithmVersion;

  public static final String JSON_PROPERTY_ALGORITHM_NAME = "algorithmName";
  @JsonProperty(JSON_PROPERTY_ALGORITHM_NAME)
  private String algorithmName;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  private Integer flowNodeId;

  public static final String JSON_PROPERTY_PARAMETERS = "parameters";
  @JsonProperty(JSON_PROPERTY_PARAMETERS)
  private List<AlgorithmParameter> parameters = null;

  public JobAlgorithm algorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
    return this;
  }

  /**
   * The algorithm Id associated with the job.
   * @return algorithmId
   **/
  @JsonProperty("algorithmId")
  @ApiModelProperty(value = "The algorithm Id associated with the job.")
  
  public String getAlgorithmId() {
    return algorithmId;
  }

  public void setAlgorithmId(String algorithmId) {
    this.algorithmId = algorithmId;
  }

  public JobAlgorithm algorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
    return this;
  }

  /**
   * The algoritm version associated with the job.
   * @return algorithmVersion
   **/
  @JsonProperty("algorithmVersion")
  @ApiModelProperty(value = "The algoritm version associated with the job.")
  
  public String getAlgorithmVersion() {
    return algorithmVersion;
  }

  public void setAlgorithmVersion(String algorithmVersion) {
    this.algorithmVersion = algorithmVersion;
  }

  public JobAlgorithm algorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
    return this;
  }

  /**
   * The algoritm name associated with the job.
   * @return algorithmName
   **/
  @JsonProperty("algorithmName")
  @ApiModelProperty(value = "The algoritm name associated with the job.")
  
  public String getAlgorithmName() {
    return algorithmName;
  }

  public void setAlgorithmName(String algorithmName) {
    this.algorithmName = algorithmName;
  }

  public JobAlgorithm flowNodeId(Integer flowNodeId) {
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The algorithm flow node id that helps to identify algorithms with same name and version when job is a flow.
   * @return flowNodeId
   **/
  @JsonProperty("flowNodeId")
  @ApiModelProperty(value = "The algorithm flow node id that helps to identify algorithms with same name and version when job is a flow.")
  
  public Integer getFlowNodeId() {
    return flowNodeId;
  }

  public void setFlowNodeId(Integer flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public JobAlgorithm parameters(List<AlgorithmParameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  public JobAlgorithm addParametersItem(AlgorithmParameter parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

  /**
   * List with all algorithm parameters.
   * @return parameters
   **/
  @JsonProperty("parameters")
  @ApiModelProperty(value = "List with all algorithm parameters.")
  @Valid 
  public List<AlgorithmParameter> getParameters() {
    return parameters;
  }

  public void setParameters(List<AlgorithmParameter> parameters) {
    this.parameters = parameters;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobAlgorithm jobAlgorithm = (JobAlgorithm) o;
    return Objects.equals(this.algorithmId, jobAlgorithm.algorithmId) &&
        Objects.equals(this.algorithmVersion, jobAlgorithm.algorithmVersion) &&
        Objects.equals(this.algorithmName, jobAlgorithm.algorithmName) &&
        Objects.equals(this.flowNodeId, jobAlgorithm.flowNodeId) &&
        Objects.equals(this.parameters, jobAlgorithm.parameters);
  }

  @Override
  public int hashCode() {
    return Objects.hash(algorithmId, algorithmVersion, algorithmName, flowNodeId, parameters);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobAlgorithm {\n");
    
    sb.append("    algorithmId: ").append(toIndentedString(algorithmId)).append("\n");
    sb.append("    algorithmVersion: ").append(toIndentedString(algorithmVersion)).append("\n");
    sb.append("    algorithmName: ").append(toIndentedString(algorithmName)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

