/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.application.filter.ServiceRequestContext;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.ServiceUnavailableException;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ProjectService {
    private static final Logger LOG = Logger.getLogger(ProjectService.class);
    @Value(value="${job.history.project.permission.check.enable}")
    public boolean checkProjectPermissionEnabled;
    @Value(value="${job.history.project.permission.check.url}")
    public String projectPermissionURL;
    @Autowired
    private ServiceConfiguration config;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ServiceRequestContext serviceRequestContext;

    public boolean hasPermission(String project) throws ServiceUnavailableException {
        if (!this.checkProjectPermissionEnabled) {
            LOG.info((Object)String.format("Skipping user permission check to project %s", project));
            return true;
        }
        LOG.info((Object)String.format("Checking user permission to project %s", project));
        List projects = this.getUserProjects();
        return projects.contains(project);
    }

    public List<String> getUserProjects() throws ServiceUnavailableException {
        String token;
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.projectPermissionURL);
        String locale = this.serviceRequestContext.getLocale();
        if (locale != null) {
            builder.queryParam("locale", new Object[]{this.serviceRequestContext.getLocale()});
        }
        if ((token = this.serviceRequestContext.getToken()) == null) {
            LOG.error((Object)"Null token");
            throw new ServiceUnavailableException("Failed retrieving user projects");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("Authorization", token);
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String[].class, new Object[0]);
            return Arrays.asList((Object[])Objects.requireNonNull(response.getBody()));
        }
        catch (RestClientException e) {
            String errorMsg = "Failed retrieving user projects";
            LOG.error((Object)errorMsg, (Throwable)e);
            throw new ServiceUnavailableException(errorMsg);
        }
    }
}

