package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;


import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;

@Transactional
@Repository
public class ReplicaRepository extends JPARepository<Replica> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<Replica> getType() {
        return Replica.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public void clearEntityManager() {
        this._entityManager.clear();
    }

    public Replica findBy(long multiflowId, int lineNumber) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<Replica> criteria = builder.createQuery(Replica.class);
        Root<Replica> root = criteria.from(Replica.class);
        root.join("multiflow", JoinType.INNER);
        criteria.where(
            builder.and(
                builder.equal(root.get("multiflow"), (multiflowId)),
                builder.equal(root.get("lineNumber"), (lineNumber))
            )
        );

        try {
            return manager.createQuery(criteria).getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    public ReplicaJob findReplicaJobBy(String replicaJobId) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<ReplicaJob> criteria = builder.createQuery(ReplicaJob.class);
        Root<ReplicaJob> root = criteria.from(ReplicaJob.class);
        criteria.where(builder.equal(root.get("jobStringId"), (replicaJobId)));

        try {
            return manager.createQuery(criteria).getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    @Transactional
    public Integer getNextReplicaJobVersion(Replica replica) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<Long> criteria = builder.createQuery(Long.class);
        Root<ReplicaJob> root = criteria.from(ReplicaJob.class);
        criteria.where(
            builder.equal(root.get("replica"), replica.getId())
        );
        criteria.select(builder.count(root));
        return manager.createQuery(criteria).getSingleResult().intValue() + 1;
    }

}
