/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class MultiflowRepository
extends JPARepository<Multiflow> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<Multiflow> getType() {
        return Multiflow.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public Multiflow findById(Long multiflowId) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Multiflow.class);
        Root root = criteria.from(Multiflow.class);
        criteria.where((Expression)builder.equal((Expression)root.get("id"), (Object)multiflowId));
        return (Multiflow)manager.createQuery(criteria).getSingleResult();
    }

    public List<Multiflow> findMultiflowsByProjectId(String projectId) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Multiflow.class);
        Root root = criteria.from(Multiflow.class);
        criteria.select((Selection)root);
        criteria.where((Expression)builder.and((Expression)builder.equal(builder.coalesce((Expression)root.get("isDeleted"), (Object)false), (Object)false), (Expression)builder.equal((Expression)root.get("projectId"), (Object)projectId)));
        return manager.createQuery(criteria).getResultList();
    }
}

