/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class ReplicaRepository
extends JPARepository<Replica> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<Replica> getType() {
        return Replica.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public void clearEntityManager() {
        this._entityManager.clear();
    }

    public Replica findBy(long multiflowId, int lineNumber) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Replica.class);
        Root root = criteria.from(Replica.class);
        root.join("multiflow", JoinType.INNER);
        criteria.where((Expression)builder.and((Expression)builder.equal((Expression)root.get("multiflow"), (Object)multiflowId), (Expression)builder.equal((Expression)root.get("lineNumber"), (Object)lineNumber)));
        try {
            return (Replica)manager.createQuery(criteria).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public ReplicaJob findReplicaJobBy(String replicaJobId) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(ReplicaJob.class);
        Root root = criteria.from(ReplicaJob.class);
        criteria.where((Expression)builder.equal((Expression)root.get("jobStringId"), (Object)replicaJobId));
        try {
            return (ReplicaJob)manager.createQuery(criteria).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Transactional
    public Integer getNextReplicaJobVersion(Replica replica) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(ReplicaJob.class);
        criteria.where((Expression)builder.equal((Expression)root.get("replica"), (Object)replica.getId()));
        criteria.select((Selection)builder.count((Expression)root));
        return ((Long)manager.createQuery(criteria).getSingleResult()).intValue() + 1;
    }
}

