package br.pucrio.tecgraf.soma.job.application.filter;

import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.HttpHeaders;
import java.io.IOException;

@Component
@Order(1)
public class ServiceRequestContextFilter implements Filter {
  private static final Logger LOG = Logger.getLogger(ServiceRequestContextFilter.class);

  @Autowired private ServiceRequestContext serviceRequestContext;

  @Override
  public void doFilter(
      ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain)
      throws IOException, ServletException {
    HttpServletRequest httpRequest = (HttpServletRequest) servletRequest;

    LOG.info("Putting context in the request scope");
    serviceRequestContext.setToken(getAuthToken(httpRequest));
    serviceRequestContext.setLocale(getLocale(httpRequest));

    filterChain.doFilter(servletRequest, servletResponse);
  }

  private String getAuthToken(HttpServletRequest httpRequest) {
    return httpRequest.getHeader(HttpHeaders.AUTHORIZATION);
  }

  private String getLocale(HttpServletRequest httpRequest) {
    String localeKey = "locale";

    final String[] localeParamValues = httpRequest.getParameterValues(localeKey);
    if (localeParamValues == null || localeParamValues.length == 0) {
      return null;
    }
    return localeParamValues[0];
  }
}
