package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Flow;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;

@Transactional
@Repository
public class FlowRepository extends JPARepository<Flow> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<Flow> getType() {
        return Flow.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

}
